@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An individual conflict error.
 * @property name Name of the conflicting catalog item.
 * @property path The path of the file that has a conflicting name.
 */
public data class CatalogConflictErrorResponse(
    public val name: String,
    public val path: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.CatalogConflictErrorResponse):
            CatalogConflictErrorResponse = CatalogConflictErrorResponse(
            name = javaType.name(),
            path = javaType.path(),
        )
    }
}
