@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents an attached NetworkConnection.
 * @property domainJoinType AAD Join type of the network. This is populated based on the referenced Network Connection.
 * @property healthCheckStatus Health check status values
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property networkConnectionId The resource ID of the NetworkConnection you want to attach.
 * @property networkConnectionLocation The geo-location where the NetworkConnection resource specified in 'networkConnectionResourceId' property lives.
 * @property provisioningState The provisioning state of the resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAttachedNetworkByDevCenterResult(
    public val domainJoinType: String,
    public val healthCheckStatus: String,
    public val id: String,
    public val name: String,
    public val networkConnectionId: String,
    public val networkConnectionLocation: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetAttachedNetworkByDevCenterResult):
            GetAttachedNetworkByDevCenterResult = GetAttachedNetworkByDevCenterResult(
            domainJoinType = javaType.domainJoinType(),
            healthCheckStatus = javaType.healthCheckStatus(),
            id = javaType.id(),
            name = javaType.name(),
            networkConnectionId = javaType.networkConnectionId(),
            networkConnectionLocation = javaType.networkConnectionLocation(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
