@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A pool of Virtual Machines.
 * @property devBoxDefinitionName Name of a Dev Box definition in parent Project of this Pool
 * @property healthStatus Overall health status of the Pool. Indicates whether or not the Pool is available to create Dev Boxes.
 * @property healthStatusDetails Details on the Pool health status to help diagnose issues. This is only populated when the pool status indicates the pool is in a non-healthy state
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property licenseType Specifies the license type indicating the caller has already acquired licenses for the Dev Boxes that will be created.
 * @property localAdministrator Indicates whether owners of Dev Boxes in this pool are added as local administrators on the Dev Box.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkConnectionName Name of a Network Connection in parent Project of this Pool
 * @property provisioningState The provisioning state of the resource.
 * @property stopOnDisconnect Stop on disconnect configuration settings for Dev Boxes created in this pool.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPoolResult(
    public val devBoxDefinitionName: String,
    public val healthStatus: String,
    public val healthStatusDetails: List<HealthStatusDetailResponse>,
    public val id: String,
    public val licenseType: String,
    public val localAdministrator: String,
    public val location: String,
    public val name: String,
    public val networkConnectionName: String,
    public val provisioningState: String,
    public val stopOnDisconnect: StopOnDisconnectConfigurationResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetPoolResult):
            GetPoolResult = GetPoolResult(
            devBoxDefinitionName = javaType.devBoxDefinitionName(),
            healthStatus = javaType.healthStatus(),
            healthStatusDetails = javaType.healthStatusDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.HealthStatusDetailResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            licenseType = javaType.licenseType(),
            localAdministrator = javaType.localAdministrator(),
            location = javaType.location(),
            name = javaType.name(),
            networkConnectionName = javaType.networkConnectionName(),
            provisioningState = javaType.provisioningState(),
            stopOnDisconnect = javaType.stopOnDisconnect().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devcenter.kotlin.outputs.StopOnDisconnectConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
