@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin

import com.pulumi.azurenative.devhub.DevhubFunctions.getGitHubOAuthPlain
import com.pulumi.azurenative.devhub.DevhubFunctions.getWorkflowPlain
import com.pulumi.azurenative.devhub.kotlin.inputs.GetGitHubOAuthPlainArgs
import com.pulumi.azurenative.devhub.kotlin.inputs.GetGitHubOAuthPlainArgsBuilder
import com.pulumi.azurenative.devhub.kotlin.inputs.GetWorkflowPlainArgs
import com.pulumi.azurenative.devhub.kotlin.inputs.GetWorkflowPlainArgsBuilder
import com.pulumi.azurenative.devhub.kotlin.outputs.GetGitHubOAuthResult
import com.pulumi.azurenative.devhub.kotlin.outputs.GetWorkflowResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.devhub.kotlin.outputs.GetGitHubOAuthResult.Companion.toKotlin as getGitHubOAuthResultToKotlin
import com.pulumi.azurenative.devhub.kotlin.outputs.GetWorkflowResult.Companion.toKotlin as getWorkflowResultToKotlin

public object DevhubFunctions {
    /**
     * URL used to authorize the Developer Hub GitHub App
     * Azure REST API version: 2022-10-11-preview.
     * Other available API versions: 2022-04-01-preview, 2023-08-01.
     * @param argument null
     * @return URL used to authorize the Developer Hub GitHub App
     */
    public suspend fun getGitHubOAuth(argument: GetGitHubOAuthPlainArgs): GetGitHubOAuthResult =
        getGitHubOAuthResultToKotlin(getGitHubOAuthPlain(argument.toJava()).await())

    /**
     * @see [getGitHubOAuth].
     * @param location The name of Azure region.
     * @param redirectUrl The URL the client will redirect to on successful authentication. If empty, no redirect will occur.
     * @return URL used to authorize the Developer Hub GitHub App
     */
    public suspend fun getGitHubOAuth(location: String, redirectUrl: String? = null):
        GetGitHubOAuthResult {
        val argument = GetGitHubOAuthPlainArgs(
            location = location,
            redirectUrl = redirectUrl,
        )
        return getGitHubOAuthResultToKotlin(getGitHubOAuthPlain(argument.toJava()).await())
    }

    /**
     * @see [getGitHubOAuth].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devhub&#46;kotlin&#46;inputs&#46;GetGitHubOAuthPlainArgs].
     * @return URL used to authorize the Developer Hub GitHub App
     */
    public suspend fun getGitHubOAuth(argument: suspend GetGitHubOAuthPlainArgsBuilder.() -> Unit):
        GetGitHubOAuthResult {
        val builder = GetGitHubOAuthPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGitHubOAuthResultToKotlin(getGitHubOAuthPlain(builtArgument.toJava()).await())
    }

    /**
     * Resource representation of a workflow
     * Azure REST API version: 2022-10-11-preview.
     * Other available API versions: 2023-08-01.
     * @param argument null
     * @return Resource representation of a workflow
     */
    public suspend fun getWorkflow(argument: GetWorkflowPlainArgs): GetWorkflowResult =
        getWorkflowResultToKotlin(getWorkflowPlain(argument.toJava()).await())

    /**
     * @see [getWorkflow].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workflowName The name of the workflow resource.
     * @return Resource representation of a workflow
     */
    public suspend fun getWorkflow(resourceGroupName: String, workflowName: String):
        GetWorkflowResult {
        val argument = GetWorkflowPlainArgs(
            resourceGroupName = resourceGroupName,
            workflowName = workflowName,
        )
        return getWorkflowResultToKotlin(getWorkflowPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkflow].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;devhub&#46;kotlin&#46;inputs&#46;GetWorkflowPlainArgs].
     * @return Resource representation of a workflow
     */
    public suspend fun getWorkflow(argument: suspend GetWorkflowPlainArgsBuilder.() -> Unit):
        GetWorkflowResult {
        val builder = GetWorkflowPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkflowResultToKotlin(getWorkflowPlain(builtArgument.toJava()).await())
    }
}
