@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines the type of manifests to be generated.
 */
public enum class GenerationManifestType(
    public val javaValue: com.pulumi.azurenative.devhub.enums.GenerationManifestType,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.enums.GenerationManifestType> {
    /**
     * Helm manifests
     */
    Helm(com.pulumi.azurenative.devhub.enums.GenerationManifestType.Helm),

    /**
     * Kubernetes manifests
     */
    Kube(com.pulumi.azurenative.devhub.enums.GenerationManifestType.Kube),
    ;

    override fun toJava(): com.pulumi.azurenative.devhub.enums.GenerationManifestType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.enums.GenerationManifestType):
            GenerationManifestType = GenerationManifestType.values().first { it.javaValue == javaType }
    }
}
