@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Determines the type of manifests within the repository.
 */
public enum class ManifestType(
    public val javaValue: com.pulumi.azurenative.devhub.enums.ManifestType,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.enums.ManifestType> {
    /**
     * Repositories using helm
     */
    Helm(com.pulumi.azurenative.devhub.enums.ManifestType.Helm),

    /**
     * Repositories using kubernetes manifests
     */
    Kube(com.pulumi.azurenative.devhub.enums.ManifestType.Kube),
    ;

    override fun toJava(): com.pulumi.azurenative.devhub.enums.ManifestType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.enums.ManifestType): ManifestType =
            ManifestType.values().first { it.javaValue == javaType }
    }
}
