@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.GetGitHubOAuthPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property location The name of Azure region.
 * @property redirectUrl The URL the client will redirect to on successful authentication. If empty, no redirect will occur.
 */
public data class GetGitHubOAuthPlainArgs(
    public val location: String,
    public val redirectUrl: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.GetGitHubOAuthPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.GetGitHubOAuthPlainArgs =
        com.pulumi.azurenative.devhub.inputs.GetGitHubOAuthPlainArgs.builder()
            .location(location.let({ args0 -> args0 }))
            .redirectUrl(redirectUrl?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGitHubOAuthPlainArgs].
 */
@PulumiTagMarker
public class GetGitHubOAuthPlainArgsBuilder internal constructor() {
    private var location: String? = null

    private var redirectUrl: String? = null

    /**
     * @param value The name of Azure region.
     */
    @JvmName("tpujfinntwwtrown")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value The URL the client will redirect to on successful authentication. If empty, no redirect will occur.
     */
    @JvmName("nxqqstiswcadywgb")
    public suspend fun redirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.redirectUrl = mapped
    }

    internal fun build(): GetGitHubOAuthPlainArgs = GetGitHubOAuthPlainArgs(
        location = location ?: throw PulumiNullFieldException("location"),
        redirectUrl = redirectUrl,
    )
}
