@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information on the azure container registry
 * @property acrRegistryName ACR registry
 * @property acrRepositoryName ACR repository
 * @property acrResourceGroup ACR resource group
 * @property acrSubscriptionId ACR subscription id
 */
public data class ACRResponse(
    public val acrRegistryName: String? = null,
    public val acrRepositoryName: String? = null,
    public val acrResourceGroup: String? = null,
    public val acrSubscriptionId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.outputs.ACRResponse): ACRResponse =
            ACRResponse(
                acrRegistryName = javaType.acrRegistryName().map({ args0 -> args0 }).orElse(null),
                acrRepositoryName = javaType.acrRepositoryName().map({ args0 -> args0 }).orElse(null),
                acrResourceGroup = javaType.acrResourceGroup().map({ args0 -> args0 }).orElse(null),
                acrSubscriptionId = javaType.acrSubscriptionId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
