@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesTransportAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
 * @property ownCertificates Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
 */
public data class AssetEndpointProfilePropertiesTransportAuthenticationArgs(
    public val ownCertificates: Output<List<AssetEndpointProfilePropertiesOwnCertificatesArgs>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesTransportAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesTransportAuthenticationArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesTransportAuthenticationArgs.builder()
            .ownCertificates(
                ownCertificates.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AssetEndpointProfilePropertiesTransportAuthenticationArgs].
 */
@PulumiTagMarker
public class AssetEndpointProfilePropertiesTransportAuthenticationArgsBuilder internal constructor() {
    private var ownCertificates: Output<List<AssetEndpointProfilePropertiesOwnCertificatesArgs>>? =
        null

    /**
     * @param value Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("knqmlacbwsdlhajo")
    public suspend
    fun ownCertificates(`value`: Output<List<AssetEndpointProfilePropertiesOwnCertificatesArgs>>) {
        this.ownCertificates = value
    }

    @JvmName("xxqpvvxobkuihhwc")
    public suspend fun ownCertificates(
        vararg
        values: Output<AssetEndpointProfilePropertiesOwnCertificatesArgs>,
    ) {
        this.ownCertificates = Output.all(values.asList())
    }

    /**
     * @param values Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("kvnjepckemtspgmg")
    public suspend
    fun ownCertificates(values: List<Output<AssetEndpointProfilePropertiesOwnCertificatesArgs>>) {
        this.ownCertificates = Output.all(values)
    }

    /**
     * @param value Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("epnsnxnblitahhsv")
    public suspend
    fun ownCertificates(`value`: List<AssetEndpointProfilePropertiesOwnCertificatesArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownCertificates = mapped
    }

    /**
     * @param argument Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("mjkkbssqcsijuojh")
    public suspend
    fun ownCertificates(argument: List<suspend AssetEndpointProfilePropertiesOwnCertificatesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssetEndpointProfilePropertiesOwnCertificatesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ownCertificates = mapped
    }

    /**
     * @param argument Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("ilqmrwmfjdowoehk")
    public suspend fun ownCertificates(
        vararg
        argument: suspend AssetEndpointProfilePropertiesOwnCertificatesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AssetEndpointProfilePropertiesOwnCertificatesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ownCertificates = mapped
    }

    /**
     * @param argument Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("yerugbiejakbowhy")
    public suspend
    fun ownCertificates(argument: suspend AssetEndpointProfilePropertiesOwnCertificatesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AssetEndpointProfilePropertiesOwnCertificatesArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.ownCertificates = mapped
    }

    /**
     * @param values Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
     */
    @JvmName("druvwmxmjulabypd")
    public suspend fun ownCertificates(
        vararg
        values: AssetEndpointProfilePropertiesOwnCertificatesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ownCertificates = mapped
    }

    internal fun build(): AssetEndpointProfilePropertiesTransportAuthenticationArgs =
        AssetEndpointProfilePropertiesTransportAuthenticationArgs(
            ownCertificates = ownCertificates ?: throw PulumiNullFieldException("ownCertificates"),
        )
}
