@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesUserAuthenticationArgs.builder
import com.pulumi.azurenative.deviceregistry.kotlin.enums.Mode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the client authentication mechanism to the server.
 * @property mode Defines the mode to authenticate the user of the client at the server.
 * @property usernamePasswordCredentials Defines the username and password references when UsernamePassword user authentication mode is selected.
 * @property x509Credentials Defines the certificate reference when Certificate user authentication mode is selected.
 */
public data class AssetEndpointProfilePropertiesUserAuthenticationArgs(
    public val mode: Output<Either<String, Mode>>,
    public val usernamePasswordCredentials:
    Output<AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs>? = null,
    public val x509Credentials: Output<AssetEndpointProfilePropertiesX509CredentialsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesUserAuthenticationArgs> {
    override fun toJava():
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesUserAuthenticationArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesUserAuthenticationArgs.builder()
            .mode(
                mode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .usernamePasswordCredentials(
                usernamePasswordCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .x509Credentials(
                x509Credentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AssetEndpointProfilePropertiesUserAuthenticationArgs].
 */
@PulumiTagMarker
public class AssetEndpointProfilePropertiesUserAuthenticationArgsBuilder internal constructor() {
    private var mode: Output<Either<String, Mode>>? = null

    private var usernamePasswordCredentials:
        Output<AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs>? = null

    private var x509Credentials: Output<AssetEndpointProfilePropertiesX509CredentialsArgs>? = null

    /**
     * @param value Defines the mode to authenticate the user of the client at the server.
     */
    @JvmName("pjpdjyokpoxshxbf")
    public suspend fun mode(`value`: Output<Either<String, Mode>>) {
        this.mode = value
    }

    /**
     * @param value Defines the username and password references when UsernamePassword user authentication mode is selected.
     */
    @JvmName("xpawruoaislvikpt")
    public suspend
    fun usernamePasswordCredentials(`value`: Output<AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs>) {
        this.usernamePasswordCredentials = value
    }

    /**
     * @param value Defines the certificate reference when Certificate user authentication mode is selected.
     */
    @JvmName("eomgvwpqhjqgewdb")
    public suspend
    fun x509Credentials(`value`: Output<AssetEndpointProfilePropertiesX509CredentialsArgs>) {
        this.x509Credentials = value
    }

    /**
     * @param value Defines the mode to authenticate the user of the client at the server.
     */
    @JvmName("ssvhqawmmmuaqswp")
    public suspend fun mode(`value`: Either<String, Mode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Defines the mode to authenticate the user of the client at the server.
     */
    @JvmName("gtqdsijhxgpwakvd")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Defines the mode to authenticate the user of the client at the server.
     */
    @JvmName("jfjmdtefilywmxai")
    public fun mode(`value`: Mode) {
        val toBeMapped = Either.ofRight<String, Mode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Defines the username and password references when UsernamePassword user authentication mode is selected.
     */
    @JvmName("lbyltgirnndnfesi")
    public suspend
    fun usernamePasswordCredentials(`value`: AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernamePasswordCredentials = mapped
    }

    /**
     * @param argument Defines the username and password references when UsernamePassword user authentication mode is selected.
     */
    @JvmName("ljxtqyjbekpetdop")
    public suspend
    fun usernamePasswordCredentials(argument: suspend AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped =
            AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.usernamePasswordCredentials = mapped
    }

    /**
     * @param value Defines the certificate reference when Certificate user authentication mode is selected.
     */
    @JvmName("prunvjdefvwxfkol")
    public suspend fun x509Credentials(`value`: AssetEndpointProfilePropertiesX509CredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x509Credentials = mapped
    }

    /**
     * @param argument Defines the certificate reference when Certificate user authentication mode is selected.
     */
    @JvmName("qjlcdtjosvhqjgdi")
    public suspend
    fun x509Credentials(argument: suspend AssetEndpointProfilePropertiesX509CredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = AssetEndpointProfilePropertiesX509CredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.x509Credentials = mapped
    }

    internal fun build(): AssetEndpointProfilePropertiesUserAuthenticationArgs =
        AssetEndpointProfilePropertiesUserAuthenticationArgs(
            mode = mode ?: throw PulumiNullFieldException("mode"),
            usernamePasswordCredentials = usernamePasswordCredentials,
            x509Credentials = x509Credentials,
        )
}
