@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesX509CredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the certificate reference when Certificate user authentication mode is selected.
 * @property certificateReference A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx).
 */
public data class AssetEndpointProfilePropertiesX509CredentialsArgs(
    public val certificateReference: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesX509CredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesX509CredentialsArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesX509CredentialsArgs.builder()
            .certificateReference(certificateReference.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssetEndpointProfilePropertiesX509CredentialsArgs].
 */
@PulumiTagMarker
public class AssetEndpointProfilePropertiesX509CredentialsArgsBuilder internal constructor() {
    private var certificateReference: Output<String>? = null

    /**
     * @param value A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx).
     */
    @JvmName("ulgmibxubysuiylu")
    public suspend fun certificateReference(`value`: Output<String>) {
        this.certificateReference = value
    }

    /**
     * @param value A reference to secret containing the certificate and private key (e.g. stored as .der/.pem or .der/.pfx).
     */
    @JvmName("dhnbesysmcubfyek")
    public suspend fun certificateReference(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.certificateReference = mapped
    }

    internal fun build(): AssetEndpointProfilePropertiesX509CredentialsArgs =
        AssetEndpointProfilePropertiesX509CredentialsArgs(
            certificateReference = certificateReference ?: throw
                PulumiNullFieldException("certificateReference"),
        )
}
