@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Asset resource properties.
 * @property assetEndpointProfileUri A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
 * @property assetType Resource path to asset type (model) definition.
 * @property attributes A set of key-value pairs that contain custom attributes set by the customer.
 * @property dataPoints Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
 * @property defaultDataPointsConfiguration Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
 * @property defaultEventsConfiguration Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
 * @property description Human-readable description of the asset.
 * @property displayName Human-readable display name.
 * @property documentationUri Reference to the documentation.
 * @property enabled Enabled/Disabled status of the asset.
 * @property events Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
 * @property externalAssetId Asset id provided by the customer.
 * @property hardwareRevision Revision number of the hardware.
 * @property manufacturer Asset manufacturer name.
 * @property manufacturerUri Asset manufacturer URI.
 * @property model Asset model name.
 * @property productCode Asset product code.
 * @property serialNumber Asset serial number.
 * @property softwareRevision Revision number of the software.
 */
public data class AssetPropertiesArgs(
    public val assetEndpointProfileUri: Output<String>,
    public val assetType: Output<String>? = null,
    public val attributes: Output<Any>? = null,
    public val dataPoints: Output<List<AssetPropertiesDataPointsArgs>>? = null,
    public val defaultDataPointsConfiguration: Output<String>? = null,
    public val defaultEventsConfiguration: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val documentationUri: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val events: Output<List<AssetPropertiesEventsArgs>>? = null,
    public val externalAssetId: Output<String>? = null,
    public val hardwareRevision: Output<String>? = null,
    public val manufacturer: Output<String>? = null,
    public val manufacturerUri: Output<String>? = null,
    public val model: Output<String>? = null,
    public val productCode: Output<String>? = null,
    public val serialNumber: Output<String>? = null,
    public val softwareRevision: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesArgs.builder()
            .assetEndpointProfileUri(assetEndpointProfileUri.applyValue({ args0 -> args0 }))
            .assetType(assetType?.applyValue({ args0 -> args0 }))
            .attributes(attributes?.applyValue({ args0 -> args0 }))
            .dataPoints(
                dataPoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultDataPointsConfiguration(defaultDataPointsConfiguration?.applyValue({ args0 -> args0 }))
            .defaultEventsConfiguration(defaultEventsConfiguration?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .documentationUri(documentationUri?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .events(events?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .externalAssetId(externalAssetId?.applyValue({ args0 -> args0 }))
            .hardwareRevision(hardwareRevision?.applyValue({ args0 -> args0 }))
            .manufacturer(manufacturer?.applyValue({ args0 -> args0 }))
            .manufacturerUri(manufacturerUri?.applyValue({ args0 -> args0 }))
            .model(model?.applyValue({ args0 -> args0 }))
            .productCode(productCode?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 }))
            .softwareRevision(softwareRevision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssetPropertiesArgs].
 */
@PulumiTagMarker
public class AssetPropertiesArgsBuilder internal constructor() {
    private var assetEndpointProfileUri: Output<String>? = null

    private var assetType: Output<String>? = null

    private var attributes: Output<Any>? = null

    private var dataPoints: Output<List<AssetPropertiesDataPointsArgs>>? = null

    private var defaultDataPointsConfiguration: Output<String>? = null

    private var defaultEventsConfiguration: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var documentationUri: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var events: Output<List<AssetPropertiesEventsArgs>>? = null

    private var externalAssetId: Output<String>? = null

    private var hardwareRevision: Output<String>? = null

    private var manufacturer: Output<String>? = null

    private var manufacturerUri: Output<String>? = null

    private var model: Output<String>? = null

    private var productCode: Output<String>? = null

    private var serialNumber: Output<String>? = null

    private var softwareRevision: Output<String>? = null

    /**
     * @param value A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
     */
    @JvmName("eigmcvieaoaiiwwx")
    public suspend fun assetEndpointProfileUri(`value`: Output<String>) {
        this.assetEndpointProfileUri = value
    }

    /**
     * @param value Resource path to asset type (model) definition.
     */
    @JvmName("vbyntofcmtihhekg")
    public suspend fun assetType(`value`: Output<String>) {
        this.assetType = value
    }

    /**
     * @param value A set of key-value pairs that contain custom attributes set by the customer.
     */
    @JvmName("mjdbjvykcehbesby")
    public suspend fun attributes(`value`: Output<Any>) {
        this.attributes = value
    }

    /**
     * @param value Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("stmqoukhhwshdjnn")
    public suspend fun dataPoints(`value`: Output<List<AssetPropertiesDataPointsArgs>>) {
        this.dataPoints = value
    }

    @JvmName("bargixwjoablcrqy")
    public suspend fun dataPoints(vararg values: Output<AssetPropertiesDataPointsArgs>) {
        this.dataPoints = Output.all(values.asList())
    }

    /**
     * @param values Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("aiximjltkmtenegp")
    public suspend fun dataPoints(values: List<Output<AssetPropertiesDataPointsArgs>>) {
        this.dataPoints = Output.all(values)
    }

    /**
     * @param value Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("ukkrabfsgheokqtm")
    public suspend fun defaultDataPointsConfiguration(`value`: Output<String>) {
        this.defaultDataPointsConfiguration = value
    }

    /**
     * @param value Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("bneaamtrvofopjuk")
    public suspend fun defaultEventsConfiguration(`value`: Output<String>) {
        this.defaultEventsConfiguration = value
    }

    /**
     * @param value Human-readable description of the asset.
     */
    @JvmName("qxjceaibgjfdybkw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Human-readable display name.
     */
    @JvmName("mieeuojhajphgdqm")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Reference to the documentation.
     */
    @JvmName("ciatkkoiaibpbdrr")
    public suspend fun documentationUri(`value`: Output<String>) {
        this.documentationUri = value
    }

    /**
     * @param value Enabled/Disabled status of the asset.
     */
    @JvmName("qyegxdvqckqdtydn")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("xprkrlccsjkldopl")
    public suspend fun events(`value`: Output<List<AssetPropertiesEventsArgs>>) {
        this.events = value
    }

    @JvmName("uintdvhrtvctvlrb")
    public suspend fun events(vararg values: Output<AssetPropertiesEventsArgs>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("lrqeruvpamqxghxe")
    public suspend fun events(values: List<Output<AssetPropertiesEventsArgs>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value Asset id provided by the customer.
     */
    @JvmName("jpsutgpmhxhxitir")
    public suspend fun externalAssetId(`value`: Output<String>) {
        this.externalAssetId = value
    }

    /**
     * @param value Revision number of the hardware.
     */
    @JvmName("mwrtoihhqfatqscm")
    public suspend fun hardwareRevision(`value`: Output<String>) {
        this.hardwareRevision = value
    }

    /**
     * @param value Asset manufacturer name.
     */
    @JvmName("htgyuclfixfhhqfo")
    public suspend fun manufacturer(`value`: Output<String>) {
        this.manufacturer = value
    }

    /**
     * @param value Asset manufacturer URI.
     */
    @JvmName("juwbcbepkeahvrny")
    public suspend fun manufacturerUri(`value`: Output<String>) {
        this.manufacturerUri = value
    }

    /**
     * @param value Asset model name.
     */
    @JvmName("vhwmhaduqpotsfol")
    public suspend fun model(`value`: Output<String>) {
        this.model = value
    }

    /**
     * @param value Asset product code.
     */
    @JvmName("enanboajgnalpysx")
    public suspend fun productCode(`value`: Output<String>) {
        this.productCode = value
    }

    /**
     * @param value Asset serial number.
     */
    @JvmName("gwwmhfafiywamngn")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value Revision number of the software.
     */
    @JvmName("kvjievhnqqnjphuq")
    public suspend fun softwareRevision(`value`: Output<String>) {
        this.softwareRevision = value
    }

    /**
     * @param value A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
     */
    @JvmName("ipjjitbjfgemowil")
    public suspend fun assetEndpointProfileUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assetEndpointProfileUri = mapped
    }

    /**
     * @param value Resource path to asset type (model) definition.
     */
    @JvmName("gnuqoxxmiheahdmo")
    public suspend fun assetType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetType = mapped
    }

    /**
     * @param value A set of key-value pairs that contain custom attributes set by the customer.
     */
    @JvmName("jndgyxnlffdevdck")
    public suspend fun attributes(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("jdbmpbpugyogeang")
    public suspend fun dataPoints(`value`: List<AssetPropertiesDataPointsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("omdwlmjlerkabbec")
    public suspend
    fun dataPoints(argument: List<suspend AssetPropertiesDataPointsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssetPropertiesDataPointsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("xodlddatxsixuaqq")
    public suspend fun dataPoints(
        vararg
        argument: suspend AssetPropertiesDataPointsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AssetPropertiesDataPointsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param argument Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("ghyphxnkdhidkwvf")
    public suspend fun dataPoints(argument: suspend AssetPropertiesDataPointsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AssetPropertiesDataPointsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataPoints = mapped
    }

    /**
     * @param values Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
     */
    @JvmName("dxantsrecybbfkbp")
    public suspend fun dataPoints(vararg values: AssetPropertiesDataPointsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataPoints = mapped
    }

    /**
     * @param value Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("ncnlnxfwbrbjgkkp")
    public suspend fun defaultDataPointsConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultDataPointsConfiguration = mapped
    }

    /**
     * @param value Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
     */
    @JvmName("igsckpalquosqahc")
    public suspend fun defaultEventsConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultEventsConfiguration = mapped
    }

    /**
     * @param value Human-readable description of the asset.
     */
    @JvmName("pbmeadxluyhxvmsm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Human-readable display name.
     */
    @JvmName("adlpmyimbmefxcub")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Reference to the documentation.
     */
    @JvmName("cdmnhttvrvuilimn")
    public suspend fun documentationUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentationUri = mapped
    }

    /**
     * @param value Enabled/Disabled status of the asset.
     */
    @JvmName("evnbehpnmyvlkvgd")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("xmsviowhbgdutbcs")
    public suspend fun events(`value`: List<AssetPropertiesEventsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("rtowknnxucechvva")
    public suspend fun events(argument: List<suspend AssetPropertiesEventsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssetPropertiesEventsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("dlyscvivaopcricy")
    public suspend fun events(vararg argument: suspend AssetPropertiesEventsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssetPropertiesEventsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param argument Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("jlhdijntnfsbsqfv")
    public suspend fun events(argument: suspend AssetPropertiesEventsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AssetPropertiesEventsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.events = mapped
    }

    /**
     * @param values Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
     */
    @JvmName("cujiwpdbludkwlfm")
    public suspend fun events(vararg values: AssetPropertiesEventsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param value Asset id provided by the customer.
     */
    @JvmName("ofaecxtjqhcleejl")
    public suspend fun externalAssetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAssetId = mapped
    }

    /**
     * @param value Revision number of the hardware.
     */
    @JvmName("spdbgnjvpqqispvo")
    public suspend fun hardwareRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareRevision = mapped
    }

    /**
     * @param value Asset manufacturer name.
     */
    @JvmName("asljxddsjlgcmoan")
    public suspend fun manufacturer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manufacturer = mapped
    }

    /**
     * @param value Asset manufacturer URI.
     */
    @JvmName("qwixslqmbjmvknct")
    public suspend fun manufacturerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manufacturerUri = mapped
    }

    /**
     * @param value Asset model name.
     */
    @JvmName("mqajalkgliqhfndb")
    public suspend fun model(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param value Asset product code.
     */
    @JvmName("jprrauxfwjudhcrw")
    public suspend fun productCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productCode = mapped
    }

    /**
     * @param value Asset serial number.
     */
    @JvmName("jdsgxvltpemmypjn")
    public suspend fun serialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value Revision number of the software.
     */
    @JvmName("fpaxtghlhftkuiln")
    public suspend fun softwareRevision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareRevision = mapped
    }

    internal fun build(): AssetPropertiesArgs = AssetPropertiesArgs(
        assetEndpointProfileUri = assetEndpointProfileUri ?: throw
            PulumiNullFieldException("assetEndpointProfileUri"),
        assetType = assetType,
        attributes = attributes,
        dataPoints = dataPoints,
        defaultDataPointsConfiguration = defaultDataPointsConfiguration,
        defaultEventsConfiguration = defaultEventsConfiguration,
        description = description,
        displayName = displayName,
        documentationUri = documentationUri,
        enabled = enabled,
        events = events,
        externalAssetId = externalAssetId,
        hardwareRevision = hardwareRevision,
        manufacturer = manufacturer,
        manufacturerUri = manufacturerUri,
        model = model,
        productCode = productCode,
        serialNumber = serialNumber,
        softwareRevision = softwareRevision,
    )
}
