@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesDataPointsArgs.builder
import com.pulumi.azurenative.deviceregistry.kotlin.enums.DataPointsObservabilityMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property capabilityId The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
 * @property dataPointConfiguration Protocol-specific configuration for the data point. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
 * @property dataSource The address of the source of the data in the asset (e.g. URL) so that a client can access the data source on the asset.
 * @property name The name of the data point.
 * @property observabilityMode An indication of how the data point should be mapped to OpenTelemetry.
 */
public data class AssetPropertiesDataPointsArgs(
    public val capabilityId: Output<String>? = null,
    public val dataPointConfiguration: Output<String>? = null,
    public val dataSource: Output<String>,
    public val name: Output<String>? = null,
    public val observabilityMode: Output<Either<String, DataPointsObservabilityMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesDataPointsArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesDataPointsArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetPropertiesDataPointsArgs.builder()
            .capabilityId(capabilityId?.applyValue({ args0 -> args0 }))
            .dataPointConfiguration(dataPointConfiguration?.applyValue({ args0 -> args0 }))
            .dataSource(dataSource.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .observabilityMode(
                observabilityMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [AssetPropertiesDataPointsArgs].
 */
@PulumiTagMarker
public class AssetPropertiesDataPointsArgsBuilder internal constructor() {
    private var capabilityId: Output<String>? = null

    private var dataPointConfiguration: Output<String>? = null

    private var dataSource: Output<String>? = null

    private var name: Output<String>? = null

    private var observabilityMode: Output<Either<String, DataPointsObservabilityMode>>? = null

    /**
     * @param value The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
     */
    @JvmName("rcscyfochcegdlsn")
    public suspend fun capabilityId(`value`: Output<String>) {
        this.capabilityId = value
    }

    /**
     * @param value Protocol-specific configuration for the data point. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
     */
    @JvmName("xbeaqolaiinvdavn")
    public suspend fun dataPointConfiguration(`value`: Output<String>) {
        this.dataPointConfiguration = value
    }

    /**
     * @param value The address of the source of the data in the asset (e.g. URL) so that a client can access the data source on the asset.
     */
    @JvmName("enoijvwqodntiaks")
    public suspend fun dataSource(`value`: Output<String>) {
        this.dataSource = value
    }

    /**
     * @param value The name of the data point.
     */
    @JvmName("riqthynadrifeasd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value An indication of how the data point should be mapped to OpenTelemetry.
     */
    @JvmName("pgfvwstigolbxdfv")
    public suspend
    fun observabilityMode(`value`: Output<Either<String, DataPointsObservabilityMode>>) {
        this.observabilityMode = value
    }

    /**
     * @param value The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
     */
    @JvmName("rcgitjgkeofmcmov")
    public suspend fun capabilityId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilityId = mapped
    }

    /**
     * @param value Protocol-specific configuration for the data point. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
     */
    @JvmName("fsaqypqfsoqkgick")
    public suspend fun dataPointConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataPointConfiguration = mapped
    }

    /**
     * @param value The address of the source of the data in the asset (e.g. URL) so that a client can access the data source on the asset.
     */
    @JvmName("lfaopxirtidawabb")
    public suspend fun dataSource(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param value The name of the data point.
     */
    @JvmName("lkitqijnaynsxxpe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value An indication of how the data point should be mapped to OpenTelemetry.
     */
    @JvmName("iepjjwpasdholneu")
    public suspend fun observabilityMode(`value`: Either<String, DataPointsObservabilityMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.observabilityMode = mapped
    }

    /**
     * @param value An indication of how the data point should be mapped to OpenTelemetry.
     */
    @JvmName("ravatpxnscmvwtvl")
    public fun observabilityMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataPointsObservabilityMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.observabilityMode = mapped
    }

    /**
     * @param value An indication of how the data point should be mapped to OpenTelemetry.
     */
    @JvmName("aqqwowbmvdbfcwwc")
    public fun observabilityMode(`value`: DataPointsObservabilityMode) {
        val toBeMapped = Either.ofRight<String, DataPointsObservabilityMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.observabilityMode = mapped
    }

    internal fun build(): AssetPropertiesDataPointsArgs = AssetPropertiesDataPointsArgs(
        capabilityId = capabilityId,
        dataPointConfiguration = dataPointConfiguration,
        dataSource = dataSource ?: throw PulumiNullFieldException("dataSource"),
        name = name,
        observabilityMode = observabilityMode,
    )
}
