@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the Asset Endpoint Profile properties.
 * @property additionalConfiguration Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
 * @property provisioningState Provisioning state of the resource.
 * @property targetAddress The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
 * @property transportAuthentication Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
 * @property userAuthentication Defines the client authentication mechanism to the server.
 * @property uuid Globally unique, immutable, non-reusable id.
 */
public data class AssetEndpointProfilePropertiesResponse(
    public val additionalConfiguration: String? = null,
    public val provisioningState: String,
    public val targetAddress: String,
    public val transportAuthentication: AssetEndpointProfilePropertiesResponseTransportAuthentication? =
        null,
    public val userAuthentication: AssetEndpointProfilePropertiesResponseUserAuthentication? = null,
    public val uuid: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetEndpointProfilePropertiesResponse):
            AssetEndpointProfilePropertiesResponse = AssetEndpointProfilePropertiesResponse(
            additionalConfiguration = javaType.additionalConfiguration().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            targetAddress = javaType.targetAddress(),
            transportAuthentication = javaType.transportAuthentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetEndpointProfilePropertiesResponseTransportAuthentication.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userAuthentication = javaType.userAuthentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetEndpointProfilePropertiesResponseUserAuthentication.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uuid = javaType.uuid(),
        )
    }
}
