@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the username and password references when UsernamePassword user authentication mode is selected.
 * @property passwordReference A reference to secret containing the password.
 * @property usernameReference A reference to secret containing the username.
 */
public data class AssetEndpointProfilePropertiesResponseUsernamePasswordCredentials(
    public val passwordReference: String,
    public val usernameReference: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetEndpointProfilePropertiesResponseUsernamePasswordCredentials):
            AssetEndpointProfilePropertiesResponseUsernamePasswordCredentials =
            AssetEndpointProfilePropertiesResponseUsernamePasswordCredentials(
                passwordReference = javaType.passwordReference(),
                usernameReference = javaType.usernameReference(),
            )
    }
}
