@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property capabilityId The path to the type definition of the capability (e.g. DTMI, OPC UA information model node id, etc.), for example dtmi:com:example:Robot:_contents:__prop1;1.
 * @property eventConfiguration Protocol-specific configuration for the event. For OPC UA, this could include configuration like, publishingInterval, samplingInterval, and queueSize.
 * @property eventNotifier The address of the notifier of the event in the asset (e.g. URL) so that a client can access the event on the asset.
 * @property name The name of the event.
 * @property observabilityMode An indication of how the event should be mapped to OpenTelemetry.
 */
public data class AssetPropertiesResponseEvents(
    public val capabilityId: String? = null,
    public val eventConfiguration: String? = null,
    public val eventNotifier: String,
    public val name: String? = null,
    public val observabilityMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetPropertiesResponseEvents):
            AssetPropertiesResponseEvents = AssetPropertiesResponseEvents(
            capabilityId = javaType.capabilityId().map({ args0 -> args0 }).orElse(null),
            eventConfiguration = javaType.eventConfiguration().map({ args0 -> args0 }).orElse(null),
            eventNotifier = javaType.eventNotifier(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            observabilityMode = javaType.observabilityMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
