@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.DpsCertificateArgs.builder
import com.pulumi.azurenative.devices.kotlin.inputs.CertificatePropertiesArgs
import com.pulumi.azurenative.devices.kotlin.inputs.CertificatePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The X509 Certificate.
 * Azure REST API version: 2022-12-12. Prior API version in Azure Native 1.x: 2020-03-01.
 * Other available API versions: 2021-10-15, 2023-03-01-preview.
 * ## Example Usage
 * ### DPSCreateOrUpdateCertificate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dpsCertificate = new AzureNative.Devices.DpsCertificate("dpsCertificate", new()
 *     {
 *         CertificateName = "cert",
 *         Properties = new AzureNative.Devices.Inputs.CertificatePropertiesArgs
 *         {
 *             Certificate = "MA==",
 *         },
 *         ProvisioningServiceName = "myFirstProvisioningService",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewDpsCertificate(ctx, "dpsCertificate", &devices.DpsCertificateArgs{
 * 			CertificateName: pulumi.String("cert"),
 * 			Properties: &devices.CertificatePropertiesArgs{
 * 				Certificate: pulumi.String("MA=="),
 * 			},
 * 			ProvisioningServiceName: pulumi.String("myFirstProvisioningService"),
 * 			ResourceGroupName:       pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.DpsCertificate;
 * import com.pulumi.azurenative.devices.DpsCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dpsCertificate = new DpsCertificate("dpsCertificate", DpsCertificateArgs.builder()
 *             .certificateName("cert")
 *             .properties(Map.of("certificate", "MA=="))
 *             .provisioningServiceName("myFirstProvisioningService")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:DpsCertificate cert /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/provisioningServices/{provisioningServiceName}/certificates/{certificateName}
 * ```
 * @property certificateName The name of the certificate create or update.
 * @property properties properties of a certificate
 * @property provisioningServiceName The name of the provisioning service.
 * @property resourceGroupName Resource group identifier.
 */
public data class DpsCertificateArgs(
    public val certificateName: Output<String>? = null,
    public val properties: Output<CertificatePropertiesArgs>? = null,
    public val provisioningServiceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.DpsCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.DpsCertificateArgs =
        com.pulumi.azurenative.devices.DpsCertificateArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningServiceName(provisioningServiceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DpsCertificateArgs].
 */
@PulumiTagMarker
public class DpsCertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var properties: Output<CertificatePropertiesArgs>? = null

    private var provisioningServiceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the certificate create or update.
     */
    @JvmName("peciyxiqbioqencr")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value properties of a certificate
     */
    @JvmName("hnxafmqaujyjwsrg")
    public suspend fun properties(`value`: Output<CertificatePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the provisioning service.
     */
    @JvmName("qxauvpydvkajbmia")
    public suspend fun provisioningServiceName(`value`: Output<String>) {
        this.provisioningServiceName = value
    }

    /**
     * @param value Resource group identifier.
     */
    @JvmName("nymtsylpylpynlhq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the certificate create or update.
     */
    @JvmName("qmcpjgyyndccqwex")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value properties of a certificate
     */
    @JvmName("yiubrtvnbyiwnluw")
    public suspend fun properties(`value`: CertificatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument properties of a certificate
     */
    @JvmName("wtweffayfhvqshex")
    public suspend fun properties(argument: suspend CertificatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CertificatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the provisioning service.
     */
    @JvmName("qofjhrecfxoxnfgp")
    public suspend fun provisioningServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningServiceName = mapped
    }

    /**
     * @param value Resource group identifier.
     */
    @JvmName("ppfdunirygodjftx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DpsCertificateArgs = DpsCertificateArgs(
        certificateName = certificateName,
        properties = properties,
        provisioningServiceName = provisioningServiceName,
        resourceGroupName = resourceGroupName,
    )
}
