@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IotHubResourceEventHubConsumerGroup].
 */
@PulumiTagMarker
public class IotHubResourceEventHubConsumerGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IotHubResourceEventHubConsumerGroupArgs =
        IotHubResourceEventHubConsumerGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend IotHubResourceEventHubConsumerGroupArgsBuilder.() -> Unit) {
        val builder = IotHubResourceEventHubConsumerGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IotHubResourceEventHubConsumerGroup {
        val builtJavaResource =
            com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return IotHubResourceEventHubConsumerGroup(builtJavaResource)
    }
}

/**
 * The properties of the EventHubConsumerGroupInfo object.
 * Azure REST API version: 2022-04-30-preview. Prior API version in Azure Native 1.x: 2020-08-31.
 * Other available API versions: 2017-07-01, 2021-03-03-preview, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
 * ## Example Usage
 * ### IotHubResource_CreateEventHubConsumerGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotHubResourceEventHubConsumerGroup = new AzureNative.Devices.IotHubResourceEventHubConsumerGroup("iotHubResourceEventHubConsumerGroup", new()
 *     {
 *         EventHubEndpointName = "events",
 *         Name = "test",
 *         Properties = new AzureNative.Devices.Inputs.EventHubConsumerGroupNameArgs
 *         {
 *             Name = "test",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "testHub",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewIotHubResourceEventHubConsumerGroup(ctx, "iotHubResourceEventHubConsumerGroup", &devices.IotHubResourceEventHubConsumerGroupArgs{
 * 			EventHubEndpointName: pulumi.String("events"),
 * 			Name:                 pulumi.String("test"),
 * 			Properties: &devices.EventHubConsumerGroupNameArgs{
 * 				Name: pulumi.String("test"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("testHub"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroup;
 * import com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotHubResourceEventHubConsumerGroup = new IotHubResourceEventHubConsumerGroup("iotHubResourceEventHubConsumerGroup", IotHubResourceEventHubConsumerGroupArgs.builder()
 *             .eventHubEndpointName("events")
 *             .name("test")
 *             .properties(Map.of("name", "test"))
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("testHub")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:IotHubResourceEventHubConsumerGroup test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}
 * ```
 */
public class IotHubResourceEventHubConsumerGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroup,
) : KotlinCustomResource(javaResource, IotHubResourceEventHubConsumerGroupMapper) {
    /**
     * The etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The Event Hub-compatible consumer group name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The tags.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * the resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IotHubResourceEventHubConsumerGroupMapper :
    ResourceMapper<IotHubResourceEventHubConsumerGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroup::class == javaResource::class

    override fun map(javaResource: Resource): IotHubResourceEventHubConsumerGroup =
        IotHubResourceEventHubConsumerGroup(
            javaResource as
                com.pulumi.azurenative.devices.IotHubResourceEventHubConsumerGroup,
        )
}

/**
 * @see [IotHubResourceEventHubConsumerGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IotHubResourceEventHubConsumerGroup].
 */
public suspend fun iotHubResourceEventHubConsumerGroup(
    name: String,
    block: suspend IotHubResourceEventHubConsumerGroupResourceBuilder.() -> Unit,
):
    IotHubResourceEventHubConsumerGroup {
    val builder = IotHubResourceEventHubConsumerGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IotHubResourceEventHubConsumerGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iotHubResourceEventHubConsumerGroup(name: String): IotHubResourceEventHubConsumerGroup {
    val builder = IotHubResourceEventHubConsumerGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
