@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.EncryptionPropertiesDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The encryption properties for the IoT hub.
 * @property keySource The source of the key.
 * @property keyVaultProperties The properties of the KeyVault key.
 */
public data class EncryptionPropertiesDescriptionArgs(
    public val keySource: Output<String>? = null,
    public val keyVaultProperties: Output<List<KeyVaultKeyPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.EncryptionPropertiesDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.EncryptionPropertiesDescriptionArgs =
        com.pulumi.azurenative.devices.inputs.EncryptionPropertiesDescriptionArgs.builder()
            .keySource(keySource?.applyValue({ args0 -> args0 }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionPropertiesDescriptionArgs].
 */
@PulumiTagMarker
public class EncryptionPropertiesDescriptionArgsBuilder internal constructor() {
    private var keySource: Output<String>? = null

    private var keyVaultProperties: Output<List<KeyVaultKeyPropertiesArgs>>? = null

    /**
     * @param value The source of the key.
     */
    @JvmName("ycfmwjxekhwxckjg")
    public suspend fun keySource(`value`: Output<String>) {
        this.keySource = value
    }

    /**
     * @param value The properties of the KeyVault key.
     */
    @JvmName("wapyigjoympspwdl")
    public suspend fun keyVaultProperties(`value`: Output<List<KeyVaultKeyPropertiesArgs>>) {
        this.keyVaultProperties = value
    }

    @JvmName("ardvlfwfiwoqkpgj")
    public suspend fun keyVaultProperties(vararg values: Output<KeyVaultKeyPropertiesArgs>) {
        this.keyVaultProperties = Output.all(values.asList())
    }

    /**
     * @param values The properties of the KeyVault key.
     */
    @JvmName("nioguhcieggwpsfe")
    public suspend fun keyVaultProperties(values: List<Output<KeyVaultKeyPropertiesArgs>>) {
        this.keyVaultProperties = Output.all(values)
    }

    /**
     * @param value The source of the key.
     */
    @JvmName("plkjivatxjqlmfap")
    public suspend fun keySource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The properties of the KeyVault key.
     */
    @JvmName("wayuuatndsvjsqjb")
    public suspend fun keyVaultProperties(`value`: List<KeyVaultKeyPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument The properties of the KeyVault key.
     */
    @JvmName("wptkttsmytvqxmha")
    public suspend
    fun keyVaultProperties(argument: List<suspend KeyVaultKeyPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KeyVaultKeyPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument The properties of the KeyVault key.
     */
    @JvmName("docpovruynqiyiur")
    public suspend fun keyVaultProperties(
        vararg
        argument: suspend KeyVaultKeyPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            KeyVaultKeyPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument The properties of the KeyVault key.
     */
    @JvmName("oyqbfipyftkumrmf")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultKeyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KeyVaultKeyPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param values The properties of the KeyVault key.
     */
    @JvmName("aurjjajjpyetucha")
    public suspend fun keyVaultProperties(vararg values: KeyVaultKeyPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    internal fun build(): EncryptionPropertiesDescriptionArgs = EncryptionPropertiesDescriptionArgs(
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
    )
}
