@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.EventHubPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.
 * @property partitionCount The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
 * @property retentionTimeInDays The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
 */
public data class EventHubPropertiesArgs(
    public val partitionCount: Output<Int>? = null,
    public val retentionTimeInDays: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.EventHubPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.EventHubPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.EventHubPropertiesArgs.builder()
            .partitionCount(partitionCount?.applyValue({ args0 -> args0 }))
            .retentionTimeInDays(retentionTimeInDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubPropertiesArgs].
 */
@PulumiTagMarker
public class EventHubPropertiesArgsBuilder internal constructor() {
    private var partitionCount: Output<Int>? = null

    private var retentionTimeInDays: Output<Double>? = null

    /**
     * @param value The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
     */
    @JvmName("tebxbibrrrujletk")
    public suspend fun partitionCount(`value`: Output<Int>) {
        this.partitionCount = value
    }

    /**
     * @param value The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
     */
    @JvmName("jtmygkatadobvoda")
    public suspend fun retentionTimeInDays(`value`: Output<Double>) {
        this.retentionTimeInDays = value
    }

    /**
     * @param value The number of partitions for receiving device-to-cloud messages in the Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
     */
    @JvmName("jqqvtopqkasvjxke")
    public suspend fun partitionCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionCount = mapped
    }

    /**
     * @param value The retention time for device-to-cloud messages in days. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
     */
    @JvmName("abtrteqkrmffspdx")
    public suspend fun retentionTimeInDays(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionTimeInDays = mapped
    }

    internal fun build(): EventHubPropertiesArgs = EventHubPropertiesArgs(
        partitionCount = partitionCount,
        retentionTimeInDays = retentionTimeInDays,
    )
}
