@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.IotDpsSkuInfoArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.IotDpsSku
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * List of possible provisioning service SKUs.
 * @property capacity The number of units to provision
 * @property name Sku name.
 */
public data class IotDpsSkuInfoArgs(
    public val capacity: Output<Double>? = null,
    public val name: Output<Either<String, IotDpsSku>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.IotDpsSkuInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.IotDpsSkuInfoArgs =
        com.pulumi.azurenative.devices.inputs.IotDpsSkuInfoArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IotDpsSkuInfoArgs].
 */
@PulumiTagMarker
public class IotDpsSkuInfoArgsBuilder internal constructor() {
    private var capacity: Output<Double>? = null

    private var name: Output<Either<String, IotDpsSku>>? = null

    /**
     * @param value The number of units to provision
     */
    @JvmName("saghhsecroxhyirq")
    public suspend fun capacity(`value`: Output<Double>) {
        this.capacity = value
    }

    /**
     * @param value Sku name.
     */
    @JvmName("lghhmqrqhjjacnro")
    public suspend fun name(`value`: Output<Either<String, IotDpsSku>>) {
        this.name = value
    }

    /**
     * @param value The number of units to provision
     */
    @JvmName("jiwfmkingjnukmul")
    public suspend fun capacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Sku name.
     */
    @JvmName("unkcfrfdnkbhhgfb")
    public suspend fun name(`value`: Either<String, IotDpsSku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Sku name.
     */
    @JvmName("nawlaarhflhwjcuq")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IotDpsSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Sku name.
     */
    @JvmName("noagrapambjewxoj")
    public fun name(`value`: IotDpsSku) {
        val toBeMapped = Either.ofRight<String, IotDpsSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): IotDpsSkuInfoArgs = IotDpsSkuInfoArgs(
        capacity = capacity,
        name = name,
    )
}
