@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.IotHubDefinitionDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of the IoT hub.
 * @property allocationWeight weight to apply for a given iot h.
 * @property applyAllocationPolicy flag for applying allocationPolicy or not for a given iot hub.
 * @property connectionString Connection string of the IoT hub.
 * @property location ARM region of the IoT hub.
 */
public data class IotHubDefinitionDescriptionArgs(
    public val allocationWeight: Output<Int>? = null,
    public val applyAllocationPolicy: Output<Boolean>? = null,
    public val connectionString: Output<String>,
    public val location: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.IotHubDefinitionDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.IotHubDefinitionDescriptionArgs =
        com.pulumi.azurenative.devices.inputs.IotHubDefinitionDescriptionArgs.builder()
            .allocationWeight(allocationWeight?.applyValue({ args0 -> args0 }))
            .applyAllocationPolicy(applyAllocationPolicy?.applyValue({ args0 -> args0 }))
            .connectionString(connectionString.applyValue({ args0 -> args0 }))
            .location(location.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotHubDefinitionDescriptionArgs].
 */
@PulumiTagMarker
public class IotHubDefinitionDescriptionArgsBuilder internal constructor() {
    private var allocationWeight: Output<Int>? = null

    private var applyAllocationPolicy: Output<Boolean>? = null

    private var connectionString: Output<String>? = null

    private var location: Output<String>? = null

    /**
     * @param value weight to apply for a given iot h.
     */
    @JvmName("ensdwainfrrixikm")
    public suspend fun allocationWeight(`value`: Output<Int>) {
        this.allocationWeight = value
    }

    /**
     * @param value flag for applying allocationPolicy or not for a given iot hub.
     */
    @JvmName("mvklviquxcddhnqi")
    public suspend fun applyAllocationPolicy(`value`: Output<Boolean>) {
        this.applyAllocationPolicy = value
    }

    /**
     * @param value Connection string of the IoT hub.
     */
    @JvmName("ydnaebxsddcsivaj")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value ARM region of the IoT hub.
     */
    @JvmName("flemmexppgjitpqd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value weight to apply for a given iot h.
     */
    @JvmName("crmywhivyujwmkad")
    public suspend fun allocationWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationWeight = mapped
    }

    /**
     * @param value flag for applying allocationPolicy or not for a given iot hub.
     */
    @JvmName("wqoudnqftmjfqohn")
    public suspend fun applyAllocationPolicy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyAllocationPolicy = mapped
    }

    /**
     * @param value Connection string of the IoT hub.
     */
    @JvmName("qjoscguvtvjtclab")
    public suspend fun connectionString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value ARM region of the IoT hub.
     */
    @JvmName("ekgovmrtjyyexryc")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    internal fun build(): IotHubDefinitionDescriptionArgs = IotHubDefinitionDescriptionArgs(
        allocationWeight = allocationWeight,
        applyAllocationPolicy = applyAllocationPolicy,
        connectionString = connectionString ?: throw PulumiNullFieldException("connectionString"),
        location = location ?: throw PulumiNullFieldException("location"),
    )
}
