@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.IotHubPropertiesArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.Capabilities
import com.pulumi.azurenative.devices.kotlin.enums.PublicNetworkAccess
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The properties of an IoT hub.
 * @property allowedFqdnList List of allowed FQDNs(Fully Qualified Domain Name) for egress from Iot Hub.
 * @property authorizationPolicies The shared access policies you can use to secure a connection to the IoT hub.
 * @property cloudToDevice The IoT hub cloud-to-device messaging properties.
 * @property comments IoT hub comments.
 * @property deviceStreams The device streams properties of iothub.
 * @property disableDeviceSAS If true, all device(including Edge devices but excluding modules) scoped SAS keys cannot be used for authentication.
 * @property disableLocalAuth If true, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication.
 * @property disableModuleSAS If true, all module scoped SAS keys cannot be used for authentication.
 * @property enableDataResidency This property when set to true, will enable data residency, thus, disabling disaster recovery.
 * @property enableFileUploadNotifications If True, file upload notifications are enabled.
 * @property encryption The encryption properties for the IoT hub.
 * @property eventHubEndpoints The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
 * @property features The capabilities and features enabled for the IoT hub.
 * @property ipFilterRules The IP filter rules.
 * @property messagingEndpoints The messaging endpoint properties for the file upload notification queue.
 * @property minTlsVersion Specifies the minimum TLS version to support for this hub. Can be set to "1.2" to have clients that use a TLS version below 1.2 to be rejected.
 * @property networkRuleSets Network Rule Set Properties of IotHub
 * @property privateEndpointConnections Private endpoint connections created on this IotHub
 * @property publicNetworkAccess Whether requests from Public Network are allowed
 * @property restrictOutboundNetworkAccess If true, egress from IotHub will be restricted to only the allowed FQDNs that are configured via allowedFqdnList.
 * @property rootCertificate This property store root certificate related information
 * @property routing The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
 * @property storageEndpoints The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
 */
public data class IotHubPropertiesArgs(
    public val allowedFqdnList: Output<List<String>>? = null,
    public val authorizationPolicies: Output<List<SharedAccessSignatureAuthorizationRuleArgs>>? =
        null,
    public val cloudToDevice: Output<CloudToDevicePropertiesArgs>? = null,
    public val comments: Output<String>? = null,
    public val deviceStreams: Output<IotHubPropertiesDeviceStreamsArgs>? = null,
    public val disableDeviceSAS: Output<Boolean>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val disableModuleSAS: Output<Boolean>? = null,
    public val enableDataResidency: Output<Boolean>? = null,
    public val enableFileUploadNotifications: Output<Boolean>? = null,
    public val encryption: Output<EncryptionPropertiesDescriptionArgs>? = null,
    public val eventHubEndpoints: Output<Map<String, EventHubPropertiesArgs>>? = null,
    public val features: Output<Either<String, Capabilities>>? = null,
    public val ipFilterRules: Output<List<IpFilterRuleArgs>>? = null,
    public val messagingEndpoints: Output<Map<String, MessagingEndpointPropertiesArgs>>? = null,
    public val minTlsVersion: Output<String>? = null,
    public val networkRuleSets: Output<NetworkRuleSetPropertiesArgs>? = null,
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val restrictOutboundNetworkAccess: Output<Boolean>? = null,
    public val rootCertificate: Output<RootCertificatePropertiesArgs>? = null,
    public val routing: Output<RoutingPropertiesArgs>? = null,
    public val storageEndpoints: Output<Map<String, StorageEndpointPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.IotHubPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.IotHubPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.IotHubPropertiesArgs.builder()
            .allowedFqdnList(allowedFqdnList?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authorizationPolicies(
                authorizationPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cloudToDevice(cloudToDevice?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .comments(comments?.applyValue({ args0 -> args0 }))
            .deviceStreams(deviceStreams?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disableDeviceSAS(disableDeviceSAS?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .disableModuleSAS(disableModuleSAS?.applyValue({ args0 -> args0 }))
            .enableDataResidency(enableDataResidency?.applyValue({ args0 -> args0 }))
            .enableFileUploadNotifications(enableFileUploadNotifications?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eventHubEndpoints(
                eventHubEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .features(
                features?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipFilterRules(
                ipFilterRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .messagingEndpoints(
                messagingEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .minTlsVersion(minTlsVersion?.applyValue({ args0 -> args0 }))
            .networkRuleSets(networkRuleSets?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnections(
                privateEndpointConnections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .restrictOutboundNetworkAccess(restrictOutboundNetworkAccess?.applyValue({ args0 -> args0 }))
            .rootCertificate(rootCertificate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .routing(routing?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageEndpoints(
                storageEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IotHubPropertiesArgs].
 */
@PulumiTagMarker
public class IotHubPropertiesArgsBuilder internal constructor() {
    private var allowedFqdnList: Output<List<String>>? = null

    private var authorizationPolicies: Output<List<SharedAccessSignatureAuthorizationRuleArgs>>? =
        null

    private var cloudToDevice: Output<CloudToDevicePropertiesArgs>? = null

    private var comments: Output<String>? = null

    private var deviceStreams: Output<IotHubPropertiesDeviceStreamsArgs>? = null

    private var disableDeviceSAS: Output<Boolean>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var disableModuleSAS: Output<Boolean>? = null

    private var enableDataResidency: Output<Boolean>? = null

    private var enableFileUploadNotifications: Output<Boolean>? = null

    private var encryption: Output<EncryptionPropertiesDescriptionArgs>? = null

    private var eventHubEndpoints: Output<Map<String, EventHubPropertiesArgs>>? = null

    private var features: Output<Either<String, Capabilities>>? = null

    private var ipFilterRules: Output<List<IpFilterRuleArgs>>? = null

    private var messagingEndpoints: Output<Map<String, MessagingEndpointPropertiesArgs>>? = null

    private var minTlsVersion: Output<String>? = null

    private var networkRuleSets: Output<NetworkRuleSetPropertiesArgs>? = null

    private var privateEndpointConnections: Output<List<PrivateEndpointConnectionArgs>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var restrictOutboundNetworkAccess: Output<Boolean>? = null

    private var rootCertificate: Output<RootCertificatePropertiesArgs>? = null

    private var routing: Output<RoutingPropertiesArgs>? = null

    private var storageEndpoints: Output<Map<String, StorageEndpointPropertiesArgs>>? = null

    /**
     * @param value List of allowed FQDNs(Fully Qualified Domain Name) for egress from Iot Hub.
     */
    @JvmName("qlowrbjejugvwwgi")
    public suspend fun allowedFqdnList(`value`: Output<List<String>>) {
        this.allowedFqdnList = value
    }

    @JvmName("rlmuxkjrjdqpkewb")
    public suspend fun allowedFqdnList(vararg values: Output<String>) {
        this.allowedFqdnList = Output.all(values.asList())
    }

    /**
     * @param values List of allowed FQDNs(Fully Qualified Domain Name) for egress from Iot Hub.
     */
    @JvmName("aeruwjlndfhioryy")
    public suspend fun allowedFqdnList(values: List<Output<String>>) {
        this.allowedFqdnList = Output.all(values)
    }

    /**
     * @param value The shared access policies you can use to secure a connection to the IoT hub.
     */
    @JvmName("idgkwxppfuwaowjm")
    public suspend
    fun authorizationPolicies(`value`: Output<List<SharedAccessSignatureAuthorizationRuleArgs>>) {
        this.authorizationPolicies = value
    }

    @JvmName("vnqtjlhnbbrlnvnr")
    public suspend fun authorizationPolicies(
        vararg
        values: Output<SharedAccessSignatureAuthorizationRuleArgs>,
    ) {
        this.authorizationPolicies = Output.all(values.asList())
    }

    /**
     * @param values The shared access policies you can use to secure a connection to the IoT hub.
     */
    @JvmName("jdtebpvjdgmaetkx")
    public suspend
    fun authorizationPolicies(values: List<Output<SharedAccessSignatureAuthorizationRuleArgs>>) {
        this.authorizationPolicies = Output.all(values)
    }

    /**
     * @param value The IoT hub cloud-to-device messaging properties.
     */
    @JvmName("ugvfkcxgpiqtlnif")
    public suspend fun cloudToDevice(`value`: Output<CloudToDevicePropertiesArgs>) {
        this.cloudToDevice = value
    }

    /**
     * @param value IoT hub comments.
     */
    @JvmName("txniycmbonnadpbk")
    public suspend fun comments(`value`: Output<String>) {
        this.comments = value
    }

    /**
     * @param value The device streams properties of iothub.
     */
    @JvmName("guikuctfjblpngpm")
    public suspend fun deviceStreams(`value`: Output<IotHubPropertiesDeviceStreamsArgs>) {
        this.deviceStreams = value
    }

    /**
     * @param value If true, all device(including Edge devices but excluding modules) scoped SAS keys cannot be used for authentication.
     */
    @JvmName("otetrnvippgstsjo")
    public suspend fun disableDeviceSAS(`value`: Output<Boolean>) {
        this.disableDeviceSAS = value
    }

    /**
     * @param value If true, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication.
     */
    @JvmName("wwwsllwremwuvqbu")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value If true, all module scoped SAS keys cannot be used for authentication.
     */
    @JvmName("pyjtvqverudkmhoo")
    public suspend fun disableModuleSAS(`value`: Output<Boolean>) {
        this.disableModuleSAS = value
    }

    /**
     * @param value This property when set to true, will enable data residency, thus, disabling disaster recovery.
     */
    @JvmName("cwslmncpqkdnatdv")
    public suspend fun enableDataResidency(`value`: Output<Boolean>) {
        this.enableDataResidency = value
    }

    /**
     * @param value If True, file upload notifications are enabled.
     */
    @JvmName("fhcaliefkcaerxvu")
    public suspend fun enableFileUploadNotifications(`value`: Output<Boolean>) {
        this.enableFileUploadNotifications = value
    }

    /**
     * @param value The encryption properties for the IoT hub.
     */
    @JvmName("gpqdivoqnkrpqbqm")
    public suspend fun encryption(`value`: Output<EncryptionPropertiesDescriptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
     */
    @JvmName("ftygaleyxiyivumr")
    public suspend fun eventHubEndpoints(`value`: Output<Map<String, EventHubPropertiesArgs>>) {
        this.eventHubEndpoints = value
    }

    /**
     * @param value The capabilities and features enabled for the IoT hub.
     */
    @JvmName("wwpymgfsdugxatgc")
    public suspend fun features(`value`: Output<Either<String, Capabilities>>) {
        this.features = value
    }

    /**
     * @param value The IP filter rules.
     */
    @JvmName("gewoijhsrjpfqnho")
    public suspend fun ipFilterRules(`value`: Output<List<IpFilterRuleArgs>>) {
        this.ipFilterRules = value
    }

    @JvmName("rxrvjxnyjmpixigv")
    public suspend fun ipFilterRules(vararg values: Output<IpFilterRuleArgs>) {
        this.ipFilterRules = Output.all(values.asList())
    }

    /**
     * @param values The IP filter rules.
     */
    @JvmName("yaxhbwommxpbchkg")
    public suspend fun ipFilterRules(values: List<Output<IpFilterRuleArgs>>) {
        this.ipFilterRules = Output.all(values)
    }

    /**
     * @param value The messaging endpoint properties for the file upload notification queue.
     */
    @JvmName("linijcboqkkvswmu")
    public suspend
    fun messagingEndpoints(`value`: Output<Map<String, MessagingEndpointPropertiesArgs>>) {
        this.messagingEndpoints = value
    }

    /**
     * @param value Specifies the minimum TLS version to support for this hub. Can be set to "1.2" to have clients that use a TLS version below 1.2 to be rejected.
     */
    @JvmName("uowtcjspuaciguvc")
    public suspend fun minTlsVersion(`value`: Output<String>) {
        this.minTlsVersion = value
    }

    /**
     * @param value Network Rule Set Properties of IotHub
     */
    @JvmName("yrbxutjayvowqyej")
    public suspend fun networkRuleSets(`value`: Output<NetworkRuleSetPropertiesArgs>) {
        this.networkRuleSets = value
    }

    /**
     * @param value Private endpoint connections created on this IotHub
     */
    @JvmName("sajmxjafdgktepek")
    public suspend
    fun privateEndpointConnections(`value`: Output<List<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = value
    }

    @JvmName("qiqyrncsmwsxdwaf")
    public suspend fun privateEndpointConnections(
        vararg
        values: Output<PrivateEndpointConnectionArgs>,
    ) {
        this.privateEndpointConnections = Output.all(values.asList())
    }

    /**
     * @param values Private endpoint connections created on this IotHub
     */
    @JvmName("yhsimsfymbukixmi")
    public suspend
    fun privateEndpointConnections(values: List<Output<PrivateEndpointConnectionArgs>>) {
        this.privateEndpointConnections = Output.all(values)
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("xdhvuwygjwafndwl")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value If true, egress from IotHub will be restricted to only the allowed FQDNs that are configured via allowedFqdnList.
     */
    @JvmName("iwujmraldhmraetc")
    public suspend fun restrictOutboundNetworkAccess(`value`: Output<Boolean>) {
        this.restrictOutboundNetworkAccess = value
    }

    /**
     * @param value This property store root certificate related information
     */
    @JvmName("yjycjenoeetxkuty")
    public suspend fun rootCertificate(`value`: Output<RootCertificatePropertiesArgs>) {
        this.rootCertificate = value
    }

    /**
     * @param value The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
     */
    @JvmName("hggcpqfjlmqixssv")
    public suspend fun routing(`value`: Output<RoutingPropertiesArgs>) {
        this.routing = value
    }

    /**
     * @param value The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
     */
    @JvmName("elppgsgppdlnitnb")
    public suspend fun storageEndpoints(`value`: Output<Map<String, StorageEndpointPropertiesArgs>>) {
        this.storageEndpoints = value
    }

    /**
     * @param value List of allowed FQDNs(Fully Qualified Domain Name) for egress from Iot Hub.
     */
    @JvmName("fumvidatvqrweqpr")
    public suspend fun allowedFqdnList(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedFqdnList = mapped
    }

    /**
     * @param values List of allowed FQDNs(Fully Qualified Domain Name) for egress from Iot Hub.
     */
    @JvmName("lvsuwkknfgxikloh")
    public suspend fun allowedFqdnList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedFqdnList = mapped
    }

    /**
     * @param value The shared access policies you can use to secure a connection to the IoT hub.
     */
    @JvmName("vhobwncsgiwepjlv")
    public suspend
    fun authorizationPolicies(`value`: List<SharedAccessSignatureAuthorizationRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationPolicies = mapped
    }

    /**
     * @param argument The shared access policies you can use to secure a connection to the IoT hub.
     */
    @JvmName("audhegloeisemigq")
    public suspend
    fun authorizationPolicies(argument: List<suspend SharedAccessSignatureAuthorizationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SharedAccessSignatureAuthorizationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizationPolicies = mapped
    }

    /**
     * @param argument The shared access policies you can use to secure a connection to the IoT hub.
     */
    @JvmName("bggrlnwnlbrycxnf")
    public suspend fun authorizationPolicies(
        vararg
        argument: suspend SharedAccessSignatureAuthorizationRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SharedAccessSignatureAuthorizationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizationPolicies = mapped
    }

    /**
     * @param argument The shared access policies you can use to secure a connection to the IoT hub.
     */
    @JvmName("hfngnpnyntnpimub")
    public suspend
    fun authorizationPolicies(argument: suspend SharedAccessSignatureAuthorizationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SharedAccessSignatureAuthorizationRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizationPolicies = mapped
    }

    /**
     * @param values The shared access policies you can use to secure a connection to the IoT hub.
     */
    @JvmName("rqacicuctaroixmy")
    public suspend fun authorizationPolicies(
        vararg
        values: SharedAccessSignatureAuthorizationRuleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationPolicies = mapped
    }

    /**
     * @param value The IoT hub cloud-to-device messaging properties.
     */
    @JvmName("untxjlhohbeqnsnw")
    public suspend fun cloudToDevice(`value`: CloudToDevicePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudToDevice = mapped
    }

    /**
     * @param argument The IoT hub cloud-to-device messaging properties.
     */
    @JvmName("kvxjoprxbxdqarfi")
    public suspend
    fun cloudToDevice(argument: suspend CloudToDevicePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CloudToDevicePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudToDevice = mapped
    }

    /**
     * @param value IoT hub comments.
     */
    @JvmName("rvcreshacgwliaam")
    public suspend fun comments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comments = mapped
    }

    /**
     * @param value The device streams properties of iothub.
     */
    @JvmName("dfsdctxclvqjwarr")
    public suspend fun deviceStreams(`value`: IotHubPropertiesDeviceStreamsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceStreams = mapped
    }

    /**
     * @param argument The device streams properties of iothub.
     */
    @JvmName("ofqwlrfrdxotlhkh")
    public suspend
    fun deviceStreams(argument: suspend IotHubPropertiesDeviceStreamsArgsBuilder.() -> Unit) {
        val toBeMapped = IotHubPropertiesDeviceStreamsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deviceStreams = mapped
    }

    /**
     * @param value If true, all device(including Edge devices but excluding modules) scoped SAS keys cannot be used for authentication.
     */
    @JvmName("kfrebeievrmstwcd")
    public suspend fun disableDeviceSAS(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableDeviceSAS = mapped
    }

    /**
     * @param value If true, SAS tokens with Iot hub scoped SAS keys cannot be used for authentication.
     */
    @JvmName("sovjkqqfyrmftoms")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value If true, all module scoped SAS keys cannot be used for authentication.
     */
    @JvmName("aimphflaygrmgarh")
    public suspend fun disableModuleSAS(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableModuleSAS = mapped
    }

    /**
     * @param value This property when set to true, will enable data residency, thus, disabling disaster recovery.
     */
    @JvmName("nicwdylkmfjdslpu")
    public suspend fun enableDataResidency(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDataResidency = mapped
    }

    /**
     * @param value If True, file upload notifications are enabled.
     */
    @JvmName("mysierghfgxvkyim")
    public suspend fun enableFileUploadNotifications(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFileUploadNotifications = mapped
    }

    /**
     * @param value The encryption properties for the IoT hub.
     */
    @JvmName("gudwwnspnjbirjsf")
    public suspend fun encryption(`value`: EncryptionPropertiesDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The encryption properties for the IoT hub.
     */
    @JvmName("kbwxjnsgrhsgplcu")
    public suspend
    fun encryption(argument: suspend EncryptionPropertiesDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
     */
    @JvmName("qxnrduxkpmpcrseo")
    public suspend fun eventHubEndpoints(`value`: Map<String, EventHubPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubEndpoints = mapped
    }

    /**
     * @param argument The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
     */
    @JvmName("spkpjmokkaonbsqo")
    public suspend fun eventHubEndpoints(
        vararg
        argument: Pair<String, suspend EventHubPropertiesArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                EventHubPropertiesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.eventHubEndpoints = mapped
    }

    /**
     * @param values The Event Hub-compatible endpoint properties. The only possible keys to this dictionary is events. This key has to be present in the dictionary while making create or update calls for the IoT hub.
     */
    @JvmName("bhwucmmwgubdqxng")
    public fun eventHubEndpoints(vararg values: Pair<String, EventHubPropertiesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubEndpoints = mapped
    }

    /**
     * @param value The capabilities and features enabled for the IoT hub.
     */
    @JvmName("wqbxdyhfivgpgakp")
    public suspend fun features(`value`: Either<String, Capabilities>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param value The capabilities and features enabled for the IoT hub.
     */
    @JvmName("harkuxalgcgvivec")
    public fun features(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Capabilities>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param value The capabilities and features enabled for the IoT hub.
     */
    @JvmName("uqqohfqgxvwclpgf")
    public fun features(`value`: Capabilities) {
        val toBeMapped = Either.ofRight<String, Capabilities>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.features = mapped
    }

    /**
     * @param value The IP filter rules.
     */
    @JvmName("ubwbjsnamgbcdbvg")
    public suspend fun ipFilterRules(`value`: List<IpFilterRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipFilterRules = mapped
    }

    /**
     * @param argument The IP filter rules.
     */
    @JvmName("fftftbfdmcmhulgf")
    public suspend fun ipFilterRules(argument: List<suspend IpFilterRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpFilterRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipFilterRules = mapped
    }

    /**
     * @param argument The IP filter rules.
     */
    @JvmName("mlovocksjkmtwcsg")
    public suspend fun ipFilterRules(vararg argument: suspend IpFilterRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpFilterRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipFilterRules = mapped
    }

    /**
     * @param argument The IP filter rules.
     */
    @JvmName("qpqoatbmdwpceudi")
    public suspend fun ipFilterRules(argument: suspend IpFilterRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpFilterRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipFilterRules = mapped
    }

    /**
     * @param values The IP filter rules.
     */
    @JvmName("pewbyaakgnywrxti")
    public suspend fun ipFilterRules(vararg values: IpFilterRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipFilterRules = mapped
    }

    /**
     * @param value The messaging endpoint properties for the file upload notification queue.
     */
    @JvmName("uyhuywibmlmjdttw")
    public suspend fun messagingEndpoints(`value`: Map<String, MessagingEndpointPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messagingEndpoints = mapped
    }

    /**
     * @param argument The messaging endpoint properties for the file upload notification queue.
     */
    @JvmName("rhckxvdltujbixym")
    public suspend fun messagingEndpoints(
        vararg
        argument: Pair<String, suspend MessagingEndpointPropertiesArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                MessagingEndpointPropertiesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.messagingEndpoints = mapped
    }

    /**
     * @param values The messaging endpoint properties for the file upload notification queue.
     */
    @JvmName("scxvpueceyufdmfx")
    public fun messagingEndpoints(vararg values: Pair<String, MessagingEndpointPropertiesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messagingEndpoints = mapped
    }

    /**
     * @param value Specifies the minimum TLS version to support for this hub. Can be set to "1.2" to have clients that use a TLS version below 1.2 to be rejected.
     */
    @JvmName("nrqsetbuykfhefnf")
    public suspend fun minTlsVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minTlsVersion = mapped
    }

    /**
     * @param value Network Rule Set Properties of IotHub
     */
    @JvmName("hksxsqwmexrcmafw")
    public suspend fun networkRuleSets(`value`: NetworkRuleSetPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRuleSets = mapped
    }

    /**
     * @param argument Network Rule Set Properties of IotHub
     */
    @JvmName("slbmetwfcnbrkjxd")
    public suspend
    fun networkRuleSets(argument: suspend NetworkRuleSetPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRuleSetPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkRuleSets = mapped
    }

    /**
     * @param value Private endpoint connections created on this IotHub
     */
    @JvmName("fvusnowerkerdqub")
    public suspend fun privateEndpointConnections(`value`: List<PrivateEndpointConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections created on this IotHub
     */
    @JvmName("ioeqthffbpbhpwpo")
    public suspend
    fun privateEndpointConnections(argument: List<suspend PrivateEndpointConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections created on this IotHub
     */
    @JvmName("hbnapfqjcqccbqbd")
    public suspend fun privateEndpointConnections(
        vararg
        argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param argument Private endpoint connections created on this IotHub
     */
    @JvmName("arjunohkjoiljndb")
    public suspend
    fun privateEndpointConnections(argument: suspend PrivateEndpointConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateEndpointConnectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateEndpointConnections = mapped
    }

    /**
     * @param values Private endpoint connections created on this IotHub
     */
    @JvmName("xvseherbacruinax")
    public suspend fun privateEndpointConnections(vararg values: PrivateEndpointConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateEndpointConnections = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("chemilulyjvpfdkr")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("usqiyjqqosfoqeil")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether requests from Public Network are allowed
     */
    @JvmName("ltxmhrphuubaojaf")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value If true, egress from IotHub will be restricted to only the allowed FQDNs that are configured via allowedFqdnList.
     */
    @JvmName("jidpsirvliwdlmjw")
    public suspend fun restrictOutboundNetworkAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictOutboundNetworkAccess = mapped
    }

    /**
     * @param value This property store root certificate related information
     */
    @JvmName("vnhnvbqbbjeaindy")
    public suspend fun rootCertificate(`value`: RootCertificatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootCertificate = mapped
    }

    /**
     * @param argument This property store root certificate related information
     */
    @JvmName("wlvmfqkgpwgrogrg")
    public suspend
    fun rootCertificate(argument: suspend RootCertificatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RootCertificatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rootCertificate = mapped
    }

    /**
     * @param value The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
     */
    @JvmName("synpsjuynlrjogcd")
    public suspend fun routing(`value`: RoutingPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routing = mapped
    }

    /**
     * @param argument The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
     */
    @JvmName("lbfvwwwoxibipvlk")
    public suspend fun routing(argument: suspend RoutingPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routing = mapped
    }

    /**
     * @param value The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
     */
    @JvmName("rgpcqusudicihedy")
    public suspend fun storageEndpoints(`value`: Map<String, StorageEndpointPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEndpoints = mapped
    }

    /**
     * @param argument The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
     */
    @JvmName("svmvkbejqjdoivad")
    public suspend fun storageEndpoints(
        vararg
        argument: Pair<String, suspend StorageEndpointPropertiesArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                StorageEndpointPropertiesArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.storageEndpoints = mapped
    }

    /**
     * @param values The list of Azure Storage endpoints where you can upload files. Currently you can configure only one Azure Storage account and that MUST have its key as $default. Specifying more than one storage account causes an error to be thrown. Not specifying a value for this property when the enableFileUploadNotifications property is set to True, causes an error to be thrown.
     */
    @JvmName("xbmsumxusmpjdtmi")
    public fun storageEndpoints(vararg values: Pair<String, StorageEndpointPropertiesArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageEndpoints = mapped
    }

    internal fun build(): IotHubPropertiesArgs = IotHubPropertiesArgs(
        allowedFqdnList = allowedFqdnList,
        authorizationPolicies = authorizationPolicies,
        cloudToDevice = cloudToDevice,
        comments = comments,
        deviceStreams = deviceStreams,
        disableDeviceSAS = disableDeviceSAS,
        disableLocalAuth = disableLocalAuth,
        disableModuleSAS = disableModuleSAS,
        enableDataResidency = enableDataResidency,
        enableFileUploadNotifications = enableFileUploadNotifications,
        encryption = encryption,
        eventHubEndpoints = eventHubEndpoints,
        features = features,
        ipFilterRules = ipFilterRules,
        messagingEndpoints = messagingEndpoints,
        minTlsVersion = minTlsVersion,
        networkRuleSets = networkRuleSets,
        privateEndpointConnections = privateEndpointConnections,
        publicNetworkAccess = publicNetworkAccess,
        restrictOutboundNetworkAccess = restrictOutboundNetworkAccess,
        rootCertificate = rootCertificate,
        routing = routing,
        storageEndpoints = storageEndpoints,
    )
}
