@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.RootCertificatePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This property store root certificate related information
 * @property enableRootCertificateV2 This property when set to true, hub will use G2 cert; while it's set to false, hub uses Baltimore Cert.
 */
public data class RootCertificatePropertiesArgs(
    public val enableRootCertificateV2: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.RootCertificatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.RootCertificatePropertiesArgs =
        com.pulumi.azurenative.devices.inputs.RootCertificatePropertiesArgs.builder()
            .enableRootCertificateV2(enableRootCertificateV2?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RootCertificatePropertiesArgs].
 */
@PulumiTagMarker
public class RootCertificatePropertiesArgsBuilder internal constructor() {
    private var enableRootCertificateV2: Output<Boolean>? = null

    /**
     * @param value This property when set to true, hub will use G2 cert; while it's set to false, hub uses Baltimore Cert.
     */
    @JvmName("pagadjhguydbshin")
    public suspend fun enableRootCertificateV2(`value`: Output<Boolean>) {
        this.enableRootCertificateV2 = value
    }

    /**
     * @param value This property when set to true, hub will use G2 cert; while it's set to false, hub uses Baltimore Cert.
     */
    @JvmName("kwfquxxkcrmetski")
    public suspend fun enableRootCertificateV2(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRootCertificateV2 = mapped
    }

    internal fun build(): RootCertificatePropertiesArgs = RootCertificatePropertiesArgs(
        enableRootCertificateV2 = enableRootCertificateV2,
    )
}
