@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.RoutingCosmosDBSqlApiPropertiesArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties related to a cosmos DB sql collection endpoint.
 * @property authenticationType Method used to authenticate against the cosmos DB sql collection endpoint
 * @property collectionName The name of the cosmos DB sql collection in the cosmos DB database.
 * @property databaseName The name of the cosmos DB database in the cosmos DB account.
 * @property endpointUri The url of the cosmos DB account. It must include the protocol https://
 * @property id Id of the cosmos DB sql collection endpoint
 * @property identity Managed identity properties of routing cosmos DB collection endpoint.
 * @property name The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
 * @property partitionKeyName The name of the partition key associated with this cosmos DB sql collection if one exists. This is an optional parameter.
 * @property partitionKeyTemplate The template for generating a synthetic partition key value for use with this cosmos DB sql collection. The template must include at least one of the following placeholders: {iothub}, {deviceid}, {DD}, {MM}, and {YYYY}. Any one placeholder may be specified at most once, but order and non-placeholder components are arbitrary. This parameter is only required if PartitionKeyName is specified.
 * @property primaryKey The primary key of the cosmos DB account.
 * @property resourceGroup The name of the resource group of the cosmos DB account.
 * @property secondaryKey The secondary key of the cosmos DB account.
 * @property subscriptionId The subscription identifier of the cosmos DB account.
 */
public data class RoutingCosmosDBSqlApiPropertiesArgs(
    public val authenticationType: Output<Either<String, AuthenticationType>>? = null,
    public val collectionName: Output<String>,
    public val databaseName: Output<String>,
    public val endpointUri: Output<String>,
    public val id: Output<String>? = null,
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val name: Output<String>,
    public val partitionKeyName: Output<String>? = null,
    public val partitionKeyTemplate: Output<String>? = null,
    public val primaryKey: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val secondaryKey: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.RoutingCosmosDBSqlApiPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.RoutingCosmosDBSqlApiPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.RoutingCosmosDBSqlApiPropertiesArgs.builder()
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .collectionName(collectionName.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 }))
            .endpointUri(endpointUri.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .partitionKeyName(partitionKeyName?.applyValue({ args0 -> args0 }))
            .partitionKeyTemplate(partitionKeyTemplate?.applyValue({ args0 -> args0 }))
            .primaryKey(primaryKey?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .secondaryKey(secondaryKey?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingCosmosDBSqlApiPropertiesArgs].
 */
@PulumiTagMarker
public class RoutingCosmosDBSqlApiPropertiesArgsBuilder internal constructor() {
    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var collectionName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var endpointUri: Output<String>? = null

    private var id: Output<String>? = null

    private var identity: Output<ManagedIdentityArgs>? = null

    private var name: Output<String>? = null

    private var partitionKeyName: Output<String>? = null

    private var partitionKeyTemplate: Output<String>? = null

    private var primaryKey: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var secondaryKey: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value Method used to authenticate against the cosmos DB sql collection endpoint
     */
    @JvmName("qhdqwdskwtwtoica")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The name of the cosmos DB sql collection in the cosmos DB database.
     */
    @JvmName("mfalypuokvfnfmid")
    public suspend fun collectionName(`value`: Output<String>) {
        this.collectionName = value
    }

    /**
     * @param value The name of the cosmos DB database in the cosmos DB account.
     */
    @JvmName("ctylcjjvxfbhfylk")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The url of the cosmos DB account. It must include the protocol https://
     */
    @JvmName("ediyiwegqotsvjtj")
    public suspend fun endpointUri(`value`: Output<String>) {
        this.endpointUri = value
    }

    /**
     * @param value Id of the cosmos DB sql collection endpoint
     */
    @JvmName("qkscjbfbxpbomeyu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Managed identity properties of routing cosmos DB collection endpoint.
     */
    @JvmName("arrcreorfavxoduc")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
     */
    @JvmName("uvvmeenekswjqjln")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the partition key associated with this cosmos DB sql collection if one exists. This is an optional parameter.
     */
    @JvmName("frkyhvvlylqlrvmu")
    public suspend fun partitionKeyName(`value`: Output<String>) {
        this.partitionKeyName = value
    }

    /**
     * @param value The template for generating a synthetic partition key value for use with this cosmos DB sql collection. The template must include at least one of the following placeholders: {iothub}, {deviceid}, {DD}, {MM}, and {YYYY}. Any one placeholder may be specified at most once, but order and non-placeholder components are arbitrary. This parameter is only required if PartitionKeyName is specified.
     */
    @JvmName("edmuaatkikdttwec")
    public suspend fun partitionKeyTemplate(`value`: Output<String>) {
        this.partitionKeyTemplate = value
    }

    /**
     * @param value The primary key of the cosmos DB account.
     */
    @JvmName("yteeywhjonxlfkrp")
    public suspend fun primaryKey(`value`: Output<String>) {
        this.primaryKey = value
    }

    /**
     * @param value The name of the resource group of the cosmos DB account.
     */
    @JvmName("qxxodiyxwdyylhxh")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The secondary key of the cosmos DB account.
     */
    @JvmName("nasdhddackyoiufq")
    public suspend fun secondaryKey(`value`: Output<String>) {
        this.secondaryKey = value
    }

    /**
     * @param value The subscription identifier of the cosmos DB account.
     */
    @JvmName("kuwjqyjhfqqqjrfk")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Method used to authenticate against the cosmos DB sql collection endpoint
     */
    @JvmName("hrimdhbokckgppxr")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Method used to authenticate against the cosmos DB sql collection endpoint
     */
    @JvmName("gtxxnnppocsujhye")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Method used to authenticate against the cosmos DB sql collection endpoint
     */
    @JvmName("ofrawvhurgtbbnln")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The name of the cosmos DB sql collection in the cosmos DB database.
     */
    @JvmName("qdxrxerglqnaksam")
    public suspend fun collectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collectionName = mapped
    }

    /**
     * @param value The name of the cosmos DB database in the cosmos DB account.
     */
    @JvmName("megvsquoyajliwaw")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The url of the cosmos DB account. It must include the protocol https://
     */
    @JvmName("yrtaanjsymdwsvge")
    public suspend fun endpointUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointUri = mapped
    }

    /**
     * @param value Id of the cosmos DB sql collection endpoint
     */
    @JvmName("quueyuoknnlskbbs")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Managed identity properties of routing cosmos DB collection endpoint.
     */
    @JvmName("dbtdwljphflfqamn")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties of routing cosmos DB collection endpoint.
     */
    @JvmName("kqrutnqlhauvbawe")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
     */
    @JvmName("ahrxwcvqyvkbrixj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the partition key associated with this cosmos DB sql collection if one exists. This is an optional parameter.
     */
    @JvmName("qhauxceahyneceja")
    public suspend fun partitionKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKeyName = mapped
    }

    /**
     * @param value The template for generating a synthetic partition key value for use with this cosmos DB sql collection. The template must include at least one of the following placeholders: {iothub}, {deviceid}, {DD}, {MM}, and {YYYY}. Any one placeholder may be specified at most once, but order and non-placeholder components are arbitrary. This parameter is only required if PartitionKeyName is specified.
     */
    @JvmName("wajopftbxvtmtrvu")
    public suspend fun partitionKeyTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionKeyTemplate = mapped
    }

    /**
     * @param value The primary key of the cosmos DB account.
     */
    @JvmName("lgfoencqrubecvrh")
    public suspend fun primaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKey = mapped
    }

    /**
     * @param value The name of the resource group of the cosmos DB account.
     */
    @JvmName("stiolmfigtgkkqod")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The secondary key of the cosmos DB account.
     */
    @JvmName("kedfcsjonqsbblne")
    public suspend fun secondaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryKey = mapped
    }

    /**
     * @param value The subscription identifier of the cosmos DB account.
     */
    @JvmName("khdmlxqpktxjxetm")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): RoutingCosmosDBSqlApiPropertiesArgs = RoutingCosmosDBSqlApiPropertiesArgs(
        authenticationType = authenticationType,
        collectionName = collectionName ?: throw PulumiNullFieldException("collectionName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        endpointUri = endpointUri ?: throw PulumiNullFieldException("endpointUri"),
        id = id,
        identity = identity,
        name = name ?: throw PulumiNullFieldException("name"),
        partitionKeyName = partitionKeyName,
        partitionKeyTemplate = partitionKeyTemplate,
        primaryKey = primaryKey,
        resourceGroup = resourceGroup,
        secondaryKey = secondaryKey,
        subscriptionId = subscriptionId,
    )
}
