@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.RoutingEndpointsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
 * @property cosmosDBSqlCollections The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
 * @property eventHubs The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
 * @property serviceBusQueues The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
 * @property serviceBusTopics The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
 * @property storageContainers The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
 */
public data class RoutingEndpointsArgs(
    public val cosmosDBSqlCollections: Output<List<RoutingCosmosDBSqlApiPropertiesArgs>>? = null,
    public val eventHubs: Output<List<RoutingEventHubPropertiesArgs>>? = null,
    public val serviceBusQueues: Output<List<RoutingServiceBusQueueEndpointPropertiesArgs>>? = null,
    public val serviceBusTopics: Output<List<RoutingServiceBusTopicEndpointPropertiesArgs>>? = null,
    public val storageContainers: Output<List<RoutingStorageContainerPropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.RoutingEndpointsArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.RoutingEndpointsArgs =
        com.pulumi.azurenative.devices.inputs.RoutingEndpointsArgs.builder()
            .cosmosDBSqlCollections(
                cosmosDBSqlCollections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eventHubs(
                eventHubs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceBusQueues(
                serviceBusQueues?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceBusTopics(
                serviceBusTopics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storageContainers(
                storageContainers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RoutingEndpointsArgs].
 */
@PulumiTagMarker
public class RoutingEndpointsArgsBuilder internal constructor() {
    private var cosmosDBSqlCollections: Output<List<RoutingCosmosDBSqlApiPropertiesArgs>>? = null

    private var eventHubs: Output<List<RoutingEventHubPropertiesArgs>>? = null

    private var serviceBusQueues: Output<List<RoutingServiceBusQueueEndpointPropertiesArgs>>? = null

    private var serviceBusTopics: Output<List<RoutingServiceBusTopicEndpointPropertiesArgs>>? = null

    private var storageContainers: Output<List<RoutingStorageContainerPropertiesArgs>>? = null

    /**
     * @param value The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("dytkkvfdrlhsfkvw")
    public suspend
    fun cosmosDBSqlCollections(`value`: Output<List<RoutingCosmosDBSqlApiPropertiesArgs>>) {
        this.cosmosDBSqlCollections = value
    }

    @JvmName("uquidxnnyocfcepe")
    public suspend fun cosmosDBSqlCollections(
        vararg
        values: Output<RoutingCosmosDBSqlApiPropertiesArgs>,
    ) {
        this.cosmosDBSqlCollections = Output.all(values.asList())
    }

    /**
     * @param values The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("aspqvihepavyojmn")
    public suspend
    fun cosmosDBSqlCollections(values: List<Output<RoutingCosmosDBSqlApiPropertiesArgs>>) {
        this.cosmosDBSqlCollections = Output.all(values)
    }

    /**
     * @param value The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("pkpokejgsdpawunc")
    public suspend fun eventHubs(`value`: Output<List<RoutingEventHubPropertiesArgs>>) {
        this.eventHubs = value
    }

    @JvmName("wjxbiwiwvdbleaxe")
    public suspend fun eventHubs(vararg values: Output<RoutingEventHubPropertiesArgs>) {
        this.eventHubs = Output.all(values.asList())
    }

    /**
     * @param values The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("tgjxlvlseqnfdprl")
    public suspend fun eventHubs(values: List<Output<RoutingEventHubPropertiesArgs>>) {
        this.eventHubs = Output.all(values)
    }

    /**
     * @param value The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("xnvcxbieyjguxhbk")
    public suspend
    fun serviceBusQueues(`value`: Output<List<RoutingServiceBusQueueEndpointPropertiesArgs>>) {
        this.serviceBusQueues = value
    }

    @JvmName("wecholbmstgfgilo")
    public suspend fun serviceBusQueues(
        vararg
        values: Output<RoutingServiceBusQueueEndpointPropertiesArgs>,
    ) {
        this.serviceBusQueues = Output.all(values.asList())
    }

    /**
     * @param values The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("jwrbnlwqtsydwwtg")
    public suspend
    fun serviceBusQueues(values: List<Output<RoutingServiceBusQueueEndpointPropertiesArgs>>) {
        this.serviceBusQueues = Output.all(values)
    }

    /**
     * @param value The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("epxhgxkfrwypqwth")
    public suspend
    fun serviceBusTopics(`value`: Output<List<RoutingServiceBusTopicEndpointPropertiesArgs>>) {
        this.serviceBusTopics = value
    }

    @JvmName("dbqkenlmowlilwfr")
    public suspend fun serviceBusTopics(
        vararg
        values: Output<RoutingServiceBusTopicEndpointPropertiesArgs>,
    ) {
        this.serviceBusTopics = Output.all(values.asList())
    }

    /**
     * @param values The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("bbqbjbnywwupnfne")
    public suspend
    fun serviceBusTopics(values: List<Output<RoutingServiceBusTopicEndpointPropertiesArgs>>) {
        this.serviceBusTopics = Output.all(values)
    }

    /**
     * @param value The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("uorakqgcmefktien")
    public suspend
    fun storageContainers(`value`: Output<List<RoutingStorageContainerPropertiesArgs>>) {
        this.storageContainers = value
    }

    @JvmName("aocghlfgxhwmfmtq")
    public suspend fun storageContainers(
        vararg
        values: Output<RoutingStorageContainerPropertiesArgs>,
    ) {
        this.storageContainers = Output.all(values.asList())
    }

    /**
     * @param values The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("hfotpfnrwlmdutqi")
    public suspend
    fun storageContainers(values: List<Output<RoutingStorageContainerPropertiesArgs>>) {
        this.storageContainers = Output.all(values)
    }

    /**
     * @param value The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("xpiiijivdnobrpvq")
    public suspend fun cosmosDBSqlCollections(`value`: List<RoutingCosmosDBSqlApiPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param argument The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("pgjjsfdecjsqycnc")
    public suspend
    fun cosmosDBSqlCollections(argument: List<suspend RoutingCosmosDBSqlApiPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingCosmosDBSqlApiPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param argument The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("hwqupachgxdebhda")
    public suspend fun cosmosDBSqlCollections(
        vararg
        argument: suspend RoutingCosmosDBSqlApiPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RoutingCosmosDBSqlApiPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param argument The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("smwofleadkxhuxuo")
    public suspend
    fun cosmosDBSqlCollections(argument: suspend RoutingCosmosDBSqlApiPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingCosmosDBSqlApiPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param values The list of Cosmos DB collection endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("wyjgxkramsawwabl")
    public suspend fun cosmosDBSqlCollections(vararg values: RoutingCosmosDBSqlApiPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cosmosDBSqlCollections = mapped
    }

    /**
     * @param value The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("dcbglvapqepqhlix")
    public suspend fun eventHubs(`value`: List<RoutingEventHubPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubs = mapped
    }

    /**
     * @param argument The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("bjrghfxricncypcx")
    public suspend
    fun eventHubs(argument: List<suspend RoutingEventHubPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingEventHubPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param argument The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("cspyioqljvwfdode")
    public suspend fun eventHubs(
        vararg
        argument: suspend RoutingEventHubPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RoutingEventHubPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param argument The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("eyxdgnbhnqxchdch")
    public suspend fun eventHubs(argument: suspend RoutingEventHubPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingEventHubPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.eventHubs = mapped
    }

    /**
     * @param values The list of Event Hubs endpoints that IoT hub routes messages to, based on the routing rules. This list does not include the built-in Event Hubs endpoint.
     */
    @JvmName("nlhkiejcacwsqmpv")
    public suspend fun eventHubs(vararg values: RoutingEventHubPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubs = mapped
    }

    /**
     * @param value The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("njruqotidjoimudj")
    public suspend
    fun serviceBusQueues(`value`: List<RoutingServiceBusQueueEndpointPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusQueues = mapped
    }

    /**
     * @param argument The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("dbmpgwgbatblalkw")
    public suspend
    fun serviceBusQueues(argument: List<suspend RoutingServiceBusQueueEndpointPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingServiceBusQueueEndpointPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBusQueues = mapped
    }

    /**
     * @param argument The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("cnlbppoxqhdbtpta")
    public suspend fun serviceBusQueues(
        vararg
        argument: suspend RoutingServiceBusQueueEndpointPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RoutingServiceBusQueueEndpointPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBusQueues = mapped
    }

    /**
     * @param argument The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("ghxuswhhfjlxmwcx")
    public suspend
    fun serviceBusQueues(argument: suspend RoutingServiceBusQueueEndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingServiceBusQueueEndpointPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceBusQueues = mapped
    }

    /**
     * @param values The list of Service Bus queue endpoints that IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("bahikcvopqoyqigh")
    public suspend fun serviceBusQueues(vararg values: RoutingServiceBusQueueEndpointPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceBusQueues = mapped
    }

    /**
     * @param value The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("okyesvwrjauwkxxi")
    public suspend
    fun serviceBusTopics(`value`: List<RoutingServiceBusTopicEndpointPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusTopics = mapped
    }

    /**
     * @param argument The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("qtxgjtjkijhhnsyo")
    public suspend
    fun serviceBusTopics(argument: List<suspend RoutingServiceBusTopicEndpointPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingServiceBusTopicEndpointPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBusTopics = mapped
    }

    /**
     * @param argument The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("wylwvitlaxcpogaa")
    public suspend fun serviceBusTopics(
        vararg
        argument: suspend RoutingServiceBusTopicEndpointPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RoutingServiceBusTopicEndpointPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceBusTopics = mapped
    }

    /**
     * @param argument The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("qkbuafubbadlhgdh")
    public suspend
    fun serviceBusTopics(argument: suspend RoutingServiceBusTopicEndpointPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingServiceBusTopicEndpointPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.serviceBusTopics = mapped
    }

    /**
     * @param values The list of Service Bus topic endpoints that the IoT hub routes the messages to, based on the routing rules.
     */
    @JvmName("ohdfhrjjbrpbpckg")
    public suspend fun serviceBusTopics(vararg values: RoutingServiceBusTopicEndpointPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceBusTopics = mapped
    }

    /**
     * @param value The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("msnkkhephhyukcyx")
    public suspend fun storageContainers(`value`: List<RoutingStorageContainerPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageContainers = mapped
    }

    /**
     * @param argument The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("vfowdpjnwtkiascr")
    public suspend
    fun storageContainers(argument: List<suspend RoutingStorageContainerPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutingStorageContainerPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param argument The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("qvqutydahahaadoo")
    public suspend fun storageContainers(
        vararg
        argument: suspend RoutingStorageContainerPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RoutingStorageContainerPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param argument The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("spxnbetlnddavrjl")
    public suspend
    fun storageContainers(argument: suspend RoutingStorageContainerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RoutingStorageContainerPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.storageContainers = mapped
    }

    /**
     * @param values The list of storage container endpoints that IoT hub routes messages to, based on the routing rules.
     */
    @JvmName("fovlblehdbdqvmih")
    public suspend fun storageContainers(vararg values: RoutingStorageContainerPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageContainers = mapped
    }

    internal fun build(): RoutingEndpointsArgs = RoutingEndpointsArgs(
        cosmosDBSqlCollections = cosmosDBSqlCollections,
        eventHubs = eventHubs,
        serviceBusQueues = serviceBusQueues,
        serviceBusTopics = serviceBusTopics,
        storageContainers = storageContainers,
    )
}
