@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.RoutingPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
 * @property endpoints The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
 * @property enrichments The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
 * @property fallbackRoute The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
 * @property routes The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
 */
public data class RoutingPropertiesArgs(
    public val endpoints: Output<RoutingEndpointsArgs>? = null,
    public val enrichments: Output<List<EnrichmentPropertiesArgs>>? = null,
    public val fallbackRoute: Output<FallbackRoutePropertiesArgs>? = null,
    public val routes: Output<List<RoutePropertiesArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.RoutingPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.RoutingPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.RoutingPropertiesArgs.builder()
            .endpoints(endpoints?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enrichments(
                enrichments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .fallbackRoute(fallbackRoute?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .routes(
                routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RoutingPropertiesArgs].
 */
@PulumiTagMarker
public class RoutingPropertiesArgsBuilder internal constructor() {
    private var endpoints: Output<RoutingEndpointsArgs>? = null

    private var enrichments: Output<List<EnrichmentPropertiesArgs>>? = null

    private var fallbackRoute: Output<FallbackRoutePropertiesArgs>? = null

    private var routes: Output<List<RoutePropertiesArgs>>? = null

    /**
     * @param value The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
     */
    @JvmName("nwjjmkpupepbybou")
    public suspend fun endpoints(`value`: Output<RoutingEndpointsArgs>) {
        this.endpoints = value
    }

    /**
     * @param value The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
     */
    @JvmName("ttpyssfpncshyhqn")
    public suspend fun enrichments(`value`: Output<List<EnrichmentPropertiesArgs>>) {
        this.enrichments = value
    }

    @JvmName("gaxegiovxpbuduls")
    public suspend fun enrichments(vararg values: Output<EnrichmentPropertiesArgs>) {
        this.enrichments = Output.all(values.asList())
    }

    /**
     * @param values The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
     */
    @JvmName("ytlbygwucyaugegh")
    public suspend fun enrichments(values: List<Output<EnrichmentPropertiesArgs>>) {
        this.enrichments = Output.all(values)
    }

    /**
     * @param value The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
     */
    @JvmName("wgdugrbybmitvuta")
    public suspend fun fallbackRoute(`value`: Output<FallbackRoutePropertiesArgs>) {
        this.fallbackRoute = value
    }

    /**
     * @param value The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
     */
    @JvmName("urrnefyhvevqpvxv")
    public suspend fun routes(`value`: Output<List<RoutePropertiesArgs>>) {
        this.routes = value
    }

    @JvmName("xxytleoexftjrsva")
    public suspend fun routes(vararg values: Output<RoutePropertiesArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
     */
    @JvmName("weuxisdcdlvlapwo")
    public suspend fun routes(values: List<Output<RoutePropertiesArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
     */
    @JvmName("vsgcvocgwnbngmdm")
    public suspend fun endpoints(`value`: RoutingEndpointsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
     */
    @JvmName("rylyukfellvwbnot")
    public suspend fun endpoints(argument: suspend RoutingEndpointsArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingEndpointsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param value The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
     */
    @JvmName("nkmwixguoxipusll")
    public suspend fun enrichments(`value`: List<EnrichmentPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enrichments = mapped
    }

    /**
     * @param argument The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
     */
    @JvmName("gjblhkkjybaxegce")
    public suspend
    fun enrichments(argument: List<suspend EnrichmentPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnrichmentPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.enrichments = mapped
    }

    /**
     * @param argument The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
     */
    @JvmName("yntnabhbnrevtnfv")
    public suspend fun enrichments(
        vararg
        argument: suspend EnrichmentPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EnrichmentPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.enrichments = mapped
    }

    /**
     * @param argument The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
     */
    @JvmName("dpkjelifxnvagesk")
    public suspend fun enrichments(argument: suspend EnrichmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnrichmentPropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.enrichments = mapped
    }

    /**
     * @param values The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
     */
    @JvmName("upcihvdnqxfmpocv")
    public suspend fun enrichments(vararg values: EnrichmentPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enrichments = mapped
    }

    /**
     * @param value The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
     */
    @JvmName("rujnwrcsavcthlqx")
    public suspend fun fallbackRoute(`value`: FallbackRoutePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fallbackRoute = mapped
    }

    /**
     * @param argument The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
     */
    @JvmName("rrjjkjcgjwjhvlye")
    public suspend
    fun fallbackRoute(argument: suspend FallbackRoutePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FallbackRoutePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.fallbackRoute = mapped
    }

    /**
     * @param value The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
     */
    @JvmName("uhaasnvsybnfkpit")
    public suspend fun routes(`value`: List<RoutePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
     */
    @JvmName("ibjrbsnpwtmxgoeb")
    public suspend fun routes(argument: List<suspend RoutePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RoutePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
     */
    @JvmName("cjpihbpoituwvmxi")
    public suspend fun routes(vararg argument: suspend RoutePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RoutePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
     */
    @JvmName("xyxbdojsfheunull")
    public suspend fun routes(argument: suspend RoutePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RoutePropertiesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
     */
    @JvmName("libgikkofaqrivib")
    public suspend fun routes(vararg values: RoutePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    internal fun build(): RoutingPropertiesArgs = RoutingPropertiesArgs(
        endpoints = endpoints,
        enrichments = enrichments,
        fallbackRoute = fallbackRoute,
        routes = routes,
    )
}
