@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.StorageEndpointPropertiesArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of the Azure Storage endpoint for file upload.
 * @property authenticationType Specifies authentication type being used for connecting to the storage account.
 * @property connectionString The connection string for the Azure Storage account to which files are uploaded.
 * @property containerName The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
 * @property identity Managed identity properties of storage endpoint for file upload.
 * @property sasTtlAsIso8601 The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
 */
public data class StorageEndpointPropertiesArgs(
    public val authenticationType: Output<Either<String, AuthenticationType>>? = null,
    public val connectionString: Output<String>,
    public val containerName: Output<String>,
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val sasTtlAsIso8601: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.StorageEndpointPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.StorageEndpointPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.StorageEndpointPropertiesArgs.builder()
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectionString(connectionString.applyValue({ args0 -> args0 }))
            .containerName(containerName.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sasTtlAsIso8601(sasTtlAsIso8601?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageEndpointPropertiesArgs].
 */
@PulumiTagMarker
public class StorageEndpointPropertiesArgsBuilder internal constructor() {
    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var connectionString: Output<String>? = null

    private var containerName: Output<String>? = null

    private var identity: Output<ManagedIdentityArgs>? = null

    private var sasTtlAsIso8601: Output<String>? = null

    /**
     * @param value Specifies authentication type being used for connecting to the storage account.
     */
    @JvmName("lpkklhutxcdyrsqq")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The connection string for the Azure Storage account to which files are uploaded.
     */
    @JvmName("iqdlhbgnygrctsuo")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
     */
    @JvmName("pfjupeidpjaxrbos")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Managed identity properties of storage endpoint for file upload.
     */
    @JvmName("votnecagwqqxqyfl")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
     */
    @JvmName("kasbjlxnvttkfifg")
    public suspend fun sasTtlAsIso8601(`value`: Output<String>) {
        this.sasTtlAsIso8601 = value
    }

    /**
     * @param value Specifies authentication type being used for connecting to the storage account.
     */
    @JvmName("pjkfjicvjvqadbco")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Specifies authentication type being used for connecting to the storage account.
     */
    @JvmName("nxifelpkeptfkhrm")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Specifies authentication type being used for connecting to the storage account.
     */
    @JvmName("xgjischxslgxfeff")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The connection string for the Azure Storage account to which files are uploaded.
     */
    @JvmName("sdrmtirdrubfsdks")
    public suspend fun connectionString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The name of the root container where you upload files. The container need not exist but should be creatable using the connectionString specified.
     */
    @JvmName("lotuygisaastcbkc")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Managed identity properties of storage endpoint for file upload.
     */
    @JvmName("lbhsqqloaymkvpsp")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties of storage endpoint for file upload.
     */
    @JvmName("ufctlsqbvckkbwui")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The period of time for which the SAS URI generated by IoT Hub for file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
     */
    @JvmName("lthcduxjyhlwpkuy")
    public suspend fun sasTtlAsIso8601(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasTtlAsIso8601 = mapped
    }

    internal fun build(): StorageEndpointPropertiesArgs = StorageEndpointPropertiesArgs(
        authenticationType = authenticationType,
        connectionString = connectionString ?: throw PulumiNullFieldException("connectionString"),
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        identity = identity,
        sasTtlAsIso8601 = sasTtlAsIso8601,
    )
}
