@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
 * @property endpoints The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.
 * @property enrichments The list of user-provided enrichments that the IoT hub applies to messages to be delivered to built-in and custom endpoints. See: https://aka.ms/telemetryoneventgrid
 * @property fallbackRoute The properties of the route that is used as a fall-back route when none of the conditions specified in the 'routes' section are met. This is an optional parameter. When this property is not set, the messages which do not meet any of the conditions specified in the 'routes' section get routed to the built-in eventhub endpoint.
 * @property routes The list of user-provided routing rules that the IoT hub uses to route messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and a maximum of 5 routing rules are allowed for free hubs.
 */
public data class RoutingPropertiesResponse(
    public val endpoints: RoutingEndpointsResponse? = null,
    public val enrichments: List<EnrichmentPropertiesResponse>? = null,
    public val fallbackRoute: FallbackRoutePropertiesResponse? = null,
    public val routes: List<RoutePropertiesResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.RoutingPropertiesResponse):
            RoutingPropertiesResponse = RoutingPropertiesResponse(
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RoutingEndpointsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enrichments = javaType.enrichments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.EnrichmentPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            fallbackRoute = javaType.fallbackRoute().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.FallbackRoutePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devices.kotlin.outputs.RoutePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
