@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin

import com.pulumi.azurenative.deviceupdate.DeviceupdateFunctions.getAccountPlain
import com.pulumi.azurenative.deviceupdate.DeviceupdateFunctions.getInstancePlain
import com.pulumi.azurenative.deviceupdate.DeviceupdateFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.deviceupdate.DeviceupdateFunctions.getPrivateEndpointConnectionProxyPlain
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.GetPrivateEndpointConnectionProxyPlainArgs
import com.pulumi.azurenative.deviceupdate.kotlin.inputs.GetPrivateEndpointConnectionProxyPlainArgsBuilder
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.GetInstanceResult
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.GetPrivateEndpointConnectionProxyResult
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.GetPrivateEndpointConnectionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.GetPrivateEndpointConnectionProxyResult.Companion.toKotlin as getPrivateEndpointConnectionProxyResultToKotlin
import com.pulumi.azurenative.deviceupdate.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin

public object DeviceupdateFunctions {
    /**
     * Returns account details for the given account name.
     * Azure REST API version: 2023-07-01.
     * @param argument null
     * @return Device Update account details.
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName Account name.
     * @param resourceGroupName The resource group name.
     * @return Device Update account details.
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deviceupdate&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return Device Update account details.
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns instance details for the given instance and account name.
     * Azure REST API version: 2023-07-01.
     * @param argument null
     * @return Device Update instance details.
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param accountName Account name.
     * @param instanceName Instance name.
     * @param resourceGroupName The resource group name.
     * @return Device Update instance details.
     */
    public suspend fun getInstance(
        accountName: String,
        instanceName: String,
        resourceGroupName: String,
    ): GetInstanceResult {
        val argument = GetInstancePlainArgs(
            accountName = accountName,
            instanceName = instanceName,
            resourceGroupName = resourceGroupName,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deviceupdate&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return Device Update instance details.
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit):
        GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the specified private endpoint connection associated with the device update account.
     * Azure REST API version: 2023-07-01.
     * @param argument null
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param accountName Account name.
     * @param privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
     * @param resourceGroupName The resource group name.
     * @return The Private Endpoint Connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        accountName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deviceupdate&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The Private Endpoint Connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * (INTERNAL - DO NOT USE) Get the specified private endpoint connection proxy associated with the device update account.
     * Azure REST API version: 2023-07-01.
     * @param argument null
     * @return Private endpoint connection proxy details.
     */
    public suspend
    fun getPrivateEndpointConnectionProxy(argument: GetPrivateEndpointConnectionProxyPlainArgs):
        GetPrivateEndpointConnectionProxyResult =
        getPrivateEndpointConnectionProxyResultToKotlin(getPrivateEndpointConnectionProxyPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnectionProxy].
     * @param accountName Account name.
     * @param privateEndpointConnectionProxyId The ID of the private endpoint connection proxy object.
     * @param resourceGroupName The resource group name.
     * @return Private endpoint connection proxy details.
     */
    public suspend fun getPrivateEndpointConnectionProxy(
        accountName: String,
        privateEndpointConnectionProxyId: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionProxyResult {
        val argument = GetPrivateEndpointConnectionProxyPlainArgs(
            accountName = accountName,
            privateEndpointConnectionProxyId = privateEndpointConnectionProxyId,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionProxyResultToKotlin(getPrivateEndpointConnectionProxyPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnectionProxy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deviceupdate&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionProxyPlainArgs].
     * @return Private endpoint connection proxy details.
     */
    public suspend
    fun getPrivateEndpointConnectionProxy(argument: suspend GetPrivateEndpointConnectionProxyPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionProxyResult {
        val builder = GetPrivateEndpointConnectionProxyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionProxyResultToKotlin(getPrivateEndpointConnectionProxyPlain(builtArgument.toJava()).await())
    }
}
