@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.inputs

import com.pulumi.azurenative.deviceupdate.inputs.GetPrivateEndpointConnectionProxyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Account name.
 * @property privateEndpointConnectionProxyId The ID of the private endpoint connection proxy object.
 * @property resourceGroupName The resource group name.
 */
public data class GetPrivateEndpointConnectionProxyPlainArgs(
    public val accountName: String,
    public val privateEndpointConnectionProxyId: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.deviceupdate.inputs.GetPrivateEndpointConnectionProxyPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.deviceupdate.inputs.GetPrivateEndpointConnectionProxyPlainArgs =
        com.pulumi.azurenative.deviceupdate.inputs.GetPrivateEndpointConnectionProxyPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .privateEndpointConnectionProxyId(privateEndpointConnectionProxyId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionProxyPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionProxyPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var privateEndpointConnectionProxyId: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Account name.
     */
    @JvmName("paoqjdxvdacbmcuk")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The ID of the private endpoint connection proxy object.
     */
    @JvmName("gpoglrqhskontkuv")
    public suspend fun privateEndpointConnectionProxyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionProxyId = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("dgtvmjscalwjuftm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionProxyPlainArgs =
        GetPrivateEndpointConnectionProxyPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            privateEndpointConnectionProxyId = privateEndpointConnectionProxyId ?: throw
                PulumiNullFieldException("privateEndpointConnectionProxyId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
