@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Private endpoint connection proxy object properties.
 * @property groupId Group ID.
 * @property id Connection details ID.
 * @property linkIdentifier Link ID.
 * @property memberName Member name.
 * @property privateIpAddress Private IP address.
 */
public data class ConnectionDetailsResponse(
    public val groupId: String,
    public val id: String,
    public val linkIdentifier: String,
    public val memberName: String,
    public val privateIpAddress: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.ConnectionDetailsResponse):
            ConnectionDetailsResponse = ConnectionDetailsResponse(
            groupId = javaType.groupId(),
            id = javaType.id(),
            linkIdentifier = javaType.linkIdentifier(),
            memberName = javaType.memberName(),
            privateIpAddress = javaType.privateIpAddress(),
        )
    }
}
