@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceupdate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Device Update instance details.
 * @property accountName Parent Device Update Account name which Instance belongs to.
 * @property diagnosticStorageProperties Customer-initiated diagnostic log collection storage properties
 * @property enableDiagnostics Enables or Disables the diagnostic logs collection
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property iotHubs List of IoT Hubs associated with the account.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetInstanceResult(
    public val accountName: String,
    public val diagnosticStorageProperties: DiagnosticStoragePropertiesResponse? = null,
    public val enableDiagnostics: Boolean? = null,
    public val id: String,
    public val iotHubs: List<IotHubSettingsResponse>? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.deviceupdate.outputs.GetInstanceResult):
            GetInstanceResult = GetInstanceResult(
            accountName = javaType.accountName(),
            diagnosticStorageProperties = javaType.diagnosticStorageProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.DiagnosticStoragePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableDiagnostics = javaType.enableDiagnostics().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            iotHubs = javaType.iotHubs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceupdate.kotlin.outputs.IotHubSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.deviceupdate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
