@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin

import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.AzureDevOpsOrganizationProfileResponse
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.StatefulResponse
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.StatelessAgentProfileResponse
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.VmssFabricProfileResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.AzureDevOpsOrganizationProfileResponse.Companion.toKotlin as azureDevOpsOrganizationProfileResponseToKotlin
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.VmssFabricProfileResponse.Companion.toKotlin as vmssFabricProfileResponseToKotlin

/**
 * Builder for [Pool].
 */
@PulumiTagMarker
public class PoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PoolArgs = PoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PoolArgsBuilder.() -> Unit) {
        val builder = PoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Pool {
        val builtJavaResource =
            com.pulumi.azurenative.devopsinfrastructure.Pool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Pool(builtJavaResource)
    }
}

/**
 * Concrete tracked resource types can be created by aliasing this type using a specific property type.
 * Azure REST API version: 2023-10-30-preview.
 * Other available API versions: 2023-12-13-preview.
 * ## Example Usage
 * ### Pools_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pool = new AzureNative.DevOpsInfrastructure.Pool("pool", new()
 *     {
 *         AgentProfile = new AzureNative.DevOpsInfrastructure.Inputs.StatelessAgentProfileArgs
 *         {
 *             Kind = "Stateless",
 *         },
 *         DevCenterProjectResourceId = "/subscriptions/222e81d0-cf38-4dab-baa5-289bf16baaa4/resourceGroups/rg-1es-devcenter/providers/Microsoft.DevCenter/projects/1ES",
 *         FabricProfile = new AzureNative.DevOpsInfrastructure.Inputs.VmssFabricProfileArgs
 *         {
 *             Images = new[]
 *             {
 *                 new AzureNative.DevOpsInfrastructure.Inputs.PoolImageArgs
 *                 {
 *                     ResourceId = "/MicrosoftWindowsServer/WindowsServer/2019-Datacenter/latest",
 *                 },
 *             },
 *             Kind = "Vmss",
 *             Sku = new AzureNative.DevOpsInfrastructure.Inputs.DevOpsAzureSkuArgs
 *             {
 *                 Name = "Standard_D4ads_v5",
 *             },
 *         },
 *         Location = "eastus",
 *         MaximumConcurrency = 10,
 *         OrganizationProfile = new AzureNative.DevOpsInfrastructure.Inputs.AzureDevOpsOrganizationProfileArgs
 *         {
 *             Kind = "AzureDevOps",
 *             Organizations = new[]
 *             {
 *                 new AzureNative.DevOpsInfrastructure.Inputs.OrganizationArgs
 *                 {
 *                     Url = "https://mseng.visualstudio.com",
 *                 },
 *             },
 *         },
 *         PoolName = "pool",
 *         ProvisioningState = "Succeeded",
 *         ResourceGroupName = "rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devopsinfrastructure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := devopsinfrastructure.NewPool(ctx, "pool", &devopsinfrastructure.PoolArgs{
 * AgentProfile: devopsinfrastructure.StatelessAgentProfile{
 * Kind: "Stateless",
 * },
 * DevCenterProjectResourceId: pulumi.String("/subscriptions/222e81d0-cf38-4dab-baa5-289bf16baaa4/resourceGroups/rg-1es-devcenter/providers/Microsoft.DevCenter/projects/1ES"),
 * FabricProfile: interface{}{
 * Images: devopsinfrastructure.PoolImageArray{
 * &devopsinfrastructure.PoolImageArgs{
 * ResourceId: pulumi.String("/MicrosoftWindowsServer/WindowsServer/2019-Datacenter/latest"),
 * },
 * },
 * Kind: pulumi.String("Vmss"),
 * Sku: &devopsinfrastructure.DevOpsAzureSkuArgs{
 * Name: pulumi.String("Standard_D4ads_v5"),
 * },
 * },
 * Location: pulumi.String("eastus"),
 * MaximumConcurrency: pulumi.Int(10),
 * OrganizationProfile: interface{}{
 * Kind: pulumi.String("AzureDevOps"),
 * Organizations: devopsinfrastructure.OrganizationArray{
 * &devopsinfrastructure.OrganizationArgs{
 * Url: pulumi.String("https://mseng.visualstudio.com"),
 * },
 * },
 * },
 * PoolName: pulumi.String("pool"),
 * ProvisioningState: pulumi.String("Succeeded"),
 * ResourceGroupName: pulumi.String("rg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devopsinfrastructure.Pool;
 * import com.pulumi.azurenative.devopsinfrastructure.PoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pool = new Pool("pool", PoolArgs.builder()
 *             .agentProfile(Map.of("kind", "Stateless"))
 *             .devCenterProjectResourceId("/subscriptions/222e81d0-cf38-4dab-baa5-289bf16baaa4/resourceGroups/rg-1es-devcenter/providers/Microsoft.DevCenter/projects/1ES")
 *             .fabricProfile(Map.ofEntries(
 *                 Map.entry("images", Map.of("resourceId", "/MicrosoftWindowsServer/WindowsServer/2019-Datacenter/latest")),
 *                 Map.entry("kind", "Vmss"),
 *                 Map.entry("sku", Map.of("name", "Standard_D4ads_v5"))
 *             ))
 *             .location("eastus")
 *             .maximumConcurrency(10)
 *             .organizationProfile(Map.ofEntries(
 *                 Map.entry("kind", "AzureDevOps"),
 *                 Map.entry("organizations", Map.of("url", "https://mseng.visualstudio.com"))
 *             ))
 *             .poolName("pool")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devopsinfrastructure:Pool myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevOpsInfrastructure/pools/{poolName}
 * ```
 */
public class Pool internal constructor(
    override val javaResource: com.pulumi.azurenative.devopsinfrastructure.Pool,
) : KotlinCustomResource(javaResource, PoolMapper) {
    /**
     * Defines how the machine will be handled once it executed a job.
     */
    public val agentProfile: Output<Either<StatefulResponse, StatelessAgentProfileResponse>>
        get() = javaResource.agentProfile().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.StatefulResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.StatelessAgentProfileResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * The resource id of the DevCenter Project the pool belongs to.
     */
    public val devCenterProjectResourceId: Output<String>
        get() = javaResource.devCenterProjectResourceId().applyValue({ args0 -> args0 })

    /**
     * Defines the type of fabric the agent will run on.
     */
    public val fabricProfile: Output<VmssFabricProfileResponse>
        get() = javaResource.fabricProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                vmssFabricProfileResponseToKotlin(args0)
            })
        })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Defines how many resources can there be created at any given time.
     */
    public val maximumConcurrency: Output<Int>
        get() = javaResource.maximumConcurrency().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the organization in which the pool will be used.
     */
    public val organizationProfile: Output<AzureDevOpsOrganizationProfileResponse>
        get() = javaResource.organizationProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                azureDevOpsOrganizationProfileResponseToKotlin(args0)
            })
        })

    /**
     * The status of the current operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PoolMapper : ResourceMapper<Pool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devopsinfrastructure.Pool::class == javaResource::class

    override fun map(javaResource: Resource): Pool = Pool(
        javaResource as
            com.pulumi.azurenative.devopsinfrastructure.Pool,
    )
}

/**
 * @see [Pool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pool].
 */
public suspend fun pool(name: String, block: suspend PoolResourceBuilder.() -> Unit): Pool {
    val builder = PoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pool(name: String): Pool {
    val builder = PoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
