@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.SecretsManagementSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The secret management settings of the machines in the pool.
 * @property certificateStoreLocation Where to store certificates on the machine.
 * @property keyExportable Defines if the key of the certificates should be exportable.
 * @property observedCertificates The list of certificates to install on all machines in the pool.
 */
public data class SecretsManagementSettingsArgs(
    public val certificateStoreLocation: Output<String>? = null,
    public val keyExportable: Output<Boolean>,
    public val observedCertificates: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.SecretsManagementSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.devopsinfrastructure.inputs.SecretsManagementSettingsArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.SecretsManagementSettingsArgs.builder()
            .certificateStoreLocation(certificateStoreLocation?.applyValue({ args0 -> args0 }))
            .keyExportable(keyExportable.applyValue({ args0 -> args0 }))
            .observedCertificates(
                observedCertificates.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [SecretsManagementSettingsArgs].
 */
@PulumiTagMarker
public class SecretsManagementSettingsArgsBuilder internal constructor() {
    private var certificateStoreLocation: Output<String>? = null

    private var keyExportable: Output<Boolean>? = null

    private var observedCertificates: Output<List<String>>? = null

    /**
     * @param value Where to store certificates on the machine.
     */
    @JvmName("iqsiipouqodwlwio")
    public suspend fun certificateStoreLocation(`value`: Output<String>) {
        this.certificateStoreLocation = value
    }

    /**
     * @param value Defines if the key of the certificates should be exportable.
     */
    @JvmName("jxploifabflghjkb")
    public suspend fun keyExportable(`value`: Output<Boolean>) {
        this.keyExportable = value
    }

    /**
     * @param value The list of certificates to install on all machines in the pool.
     */
    @JvmName("rjkqismhaliiqrxi")
    public suspend fun observedCertificates(`value`: Output<List<String>>) {
        this.observedCertificates = value
    }

    @JvmName("jemtnmvfhnvepckr")
    public suspend fun observedCertificates(vararg values: Output<String>) {
        this.observedCertificates = Output.all(values.asList())
    }

    /**
     * @param values The list of certificates to install on all machines in the pool.
     */
    @JvmName("hvjrgxnkvjrlbjwc")
    public suspend fun observedCertificates(values: List<Output<String>>) {
        this.observedCertificates = Output.all(values)
    }

    /**
     * @param value Where to store certificates on the machine.
     */
    @JvmName("bpburingjmqpyueh")
    public suspend fun certificateStoreLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateStoreLocation = mapped
    }

    /**
     * @param value Defines if the key of the certificates should be exportable.
     */
    @JvmName("fbnfwdeaacpwurwa")
    public suspend fun keyExportable(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyExportable = mapped
    }

    /**
     * @param value The list of certificates to install on all machines in the pool.
     */
    @JvmName("mbvegrfovccrhncl")
    public suspend fun observedCertificates(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.observedCertificates = mapped
    }

    /**
     * @param values The list of certificates to install on all machines in the pool.
     */
    @JvmName("bttunxheoimvdvst")
    public suspend fun observedCertificates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.observedCertificates = mapped
    }

    internal fun build(): SecretsManagementSettingsArgs = SecretsManagementSettingsArgs(
        certificateStoreLocation = certificateStoreLocation,
        keyExportable = keyExportable ?: throw PulumiNullFieldException("keyExportable"),
        observedCertificates = observedCertificates ?: throw
            PulumiNullFieldException("observedCertificates"),
    )
}
