@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.inputs

import com.pulumi.azurenative.devopsinfrastructure.inputs.VmssFabricProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The agents will run on Virtual Machine Scale Sets.
 * @property images The VM images of the machines in the pool.
 * @property kind Discriminator property for FabricProfile.
 * Expected value is 'Vmss'.
 * @property networkProfile The network profile of the machines in the pool.
 * @property osProfile The OS profile of the machines in the pool.
 * @property sku The Azure SKU of the machines in the pool.
 */
public data class VmssFabricProfileArgs(
    public val images: Output<List<PoolImageArgs>>,
    public val kind: Output<String>,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val osProfile: Output<OsProfileArgs>? = null,
    public val sku: Output<DevOpsAzureSkuArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.devopsinfrastructure.inputs.VmssFabricProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.devopsinfrastructure.inputs.VmssFabricProfileArgs =
        com.pulumi.azurenative.devopsinfrastructure.inputs.VmssFabricProfileArgs.builder()
            .images(images.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .kind(kind.applyValue({ args0 -> args0 }))
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sku(sku.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VmssFabricProfileArgs].
 */
@PulumiTagMarker
public class VmssFabricProfileArgsBuilder internal constructor() {
    private var images: Output<List<PoolImageArgs>>? = null

    private var kind: Output<String>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var osProfile: Output<OsProfileArgs>? = null

    private var sku: Output<DevOpsAzureSkuArgs>? = null

    /**
     * @param value The VM images of the machines in the pool.
     */
    @JvmName("xhjdrlhhkxmskhey")
    public suspend fun images(`value`: Output<List<PoolImageArgs>>) {
        this.images = value
    }

    @JvmName("imsbncggmxxwnnfs")
    public suspend fun images(vararg values: Output<PoolImageArgs>) {
        this.images = Output.all(values.asList())
    }

    /**
     * @param values The VM images of the machines in the pool.
     */
    @JvmName("qwbxovafrpgxefyq")
    public suspend fun images(values: List<Output<PoolImageArgs>>) {
        this.images = Output.all(values)
    }

    /**
     * @param value Discriminator property for FabricProfile.
     * Expected value is 'Vmss'.
     */
    @JvmName("pqivelgvbesnckko")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The network profile of the machines in the pool.
     */
    @JvmName("gjlcntdechwprfdd")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value The OS profile of the machines in the pool.
     */
    @JvmName("elfauyrjuxtxqtcv")
    public suspend fun osProfile(`value`: Output<OsProfileArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The Azure SKU of the machines in the pool.
     */
    @JvmName("vkppypqwrlokpaxe")
    public suspend fun sku(`value`: Output<DevOpsAzureSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The VM images of the machines in the pool.
     */
    @JvmName("lrmodvjgncxwdsbw")
    public suspend fun images(`value`: List<PoolImageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.images = mapped
    }

    /**
     * @param argument The VM images of the machines in the pool.
     */
    @JvmName("gbomkyvovnkcquvt")
    public suspend fun images(argument: List<suspend PoolImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PoolImageArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.images = mapped
    }

    /**
     * @param argument The VM images of the machines in the pool.
     */
    @JvmName("fvejvhqyypqdamof")
    public suspend fun images(vararg argument: suspend PoolImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PoolImageArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.images = mapped
    }

    /**
     * @param argument The VM images of the machines in the pool.
     */
    @JvmName("hyohqmgavskrpawg")
    public suspend fun images(argument: suspend PoolImageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PoolImageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.images = mapped
    }

    /**
     * @param values The VM images of the machines in the pool.
     */
    @JvmName("yfmmvnxrycoxyiwx")
    public suspend fun images(vararg values: PoolImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.images = mapped
    }

    /**
     * @param value Discriminator property for FabricProfile.
     * Expected value is 'Vmss'.
     */
    @JvmName("sdvhrrtkhhqrwnnh")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The network profile of the machines in the pool.
     */
    @JvmName("dhebccymrvtsdymu")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument The network profile of the machines in the pool.
     */
    @JvmName("hrysxwtqiexejgpj")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value The OS profile of the machines in the pool.
     */
    @JvmName("xkiulsrgypjnwave")
    public suspend fun osProfile(`value`: OsProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument The OS profile of the machines in the pool.
     */
    @JvmName("wesrflawctxdwmqf")
    public suspend fun osProfile(argument: suspend OsProfileArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The Azure SKU of the machines in the pool.
     */
    @JvmName("ctajbwjgfnxkjbtr")
    public suspend fun sku(`value`: DevOpsAzureSkuArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The Azure SKU of the machines in the pool.
     */
    @JvmName("phxhklchrsogdhgv")
    public suspend fun sku(argument: suspend DevOpsAzureSkuArgsBuilder.() -> Unit) {
        val toBeMapped = DevOpsAzureSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): VmssFabricProfileArgs = VmssFabricProfileArgs(
        images = images ?: throw PulumiNullFieldException("images"),
        kind = kind ?: throw PulumiNullFieldException("kind"),
        networkProfile = networkProfile,
        osProfile = osProfile,
        sku = sku ?: throw PulumiNullFieldException("sku"),
    )
}
