@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Stateful profile meaning that the machines will be returned to the pool after running a job.
 * @property kind Discriminator property for AgentProfile.
 * Expected value is 'Stateful'.
 * @property maxAgentLifetime How long should stateful machines be kept around. The maximum is one week.
 * @property resourcePredictions Defines pool buffer.
 */
public data class StatefulResponse(
    public val kind: String,
    public val maxAgentLifetime: String,
    public val resourcePredictions: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.StatefulResponse):
            StatefulResponse = StatefulResponse(
            kind = javaType.kind(),
            maxAgentLifetime = javaType.maxAgentLifetime(),
            resourcePredictions = javaType.resourcePredictions().map({ args0 -> args0 }).orElse(null),
        )
    }
}
