@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The agents will run on Virtual Machine Scale Sets.
 * @property images The VM images of the machines in the pool.
 * @property kind Discriminator property for FabricProfile.
 * Expected value is 'Vmss'.
 * @property networkProfile The network profile of the machines in the pool.
 * @property osProfile The OS profile of the machines in the pool.
 * @property sku The Azure SKU of the machines in the pool.
 */
public data class VmssFabricProfileResponse(
    public val images: List<PoolImageResponse>,
    public val kind: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val osProfile: OsProfileResponse? = null,
    public val sku: DevOpsAzureSkuResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devopsinfrastructure.outputs.VmssFabricProfileResponse):
            VmssFabricProfileResponse = VmssFabricProfileResponse(
            images = javaType.images().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.PoolImageResponse.Companion.toKotlin(args0)
                })
            }),
            kind = javaType.kind(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            osProfile = javaType.osProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.OsProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.devopsinfrastructure.kotlin.outputs.DevOpsAzureSkuResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
