@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin

import com.pulumi.azurenative.devspaces.ControllerArgs.builder
import com.pulumi.azurenative.devspaces.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.devspaces.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2019-04-01. Prior API version in Azure Native 1.x: 2019-04-01.
 * ## Example Usage
 * ### ControllersCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var controller = new AzureNative.DevSpaces.Controller("controller", new()
 *     {
 *         Location = "eastus",
 *         Name = "myControllerResource",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.DevSpaces.Inputs.SkuArgs
 *         {
 *             Name = "S1",
 *             Tier = "Standard",
 *         },
 *         Tags = null,
 *         TargetContainerHostCredentialsBase64 = "QmFzZTY0IEVuY29kZWQgVmFsdWUK",
 *         TargetContainerHostResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myCluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devspaces.NewController(ctx, "controller", &devspaces.ControllerArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			Name:              pulumi.String("myControllerResource"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &devspaces.SkuArgs{
 * 				Name: pulumi.String("S1"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags:                                 nil,
 * 			TargetContainerHostCredentialsBase64: pulumi.String("QmFzZTY0IEVuY29kZWQgVmFsdWUK"),
 * 			TargetContainerHostResourceId:        pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myCluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devspaces.Controller;
 * import com.pulumi.azurenative.devspaces.ControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var controller = new Controller("controller", ControllerArgs.builder()
 *             .location("eastus")
 *             .name("myControllerResource")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "S1"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags()
 *             .targetContainerHostCredentialsBase64("QmFzZTY0IEVuY29kZWQgVmFsdWUK")
 *             .targetContainerHostResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerService/managedClusters/myCluster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devspaces:Controller myControllerResource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevSpaces/controllers/{name}
 * ```
 * @property location Region where the Azure resource is located.
 * @property name Name of the resource.
 * @property resourceGroupName Resource group to which the resource belongs.
 * @property sku Model representing SKU for Azure Dev Spaces Controller.
 * @property tags Tags for the Azure resource.
 * @property targetContainerHostCredentialsBase64 Credentials of the target container host (base64).
 * @property targetContainerHostResourceId Resource ID of the target container host
 */
public data class ControllerArgs(
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetContainerHostCredentialsBase64: Output<String>? = null,
    public val targetContainerHostResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devspaces.ControllerArgs> {
    override fun toJava(): com.pulumi.azurenative.devspaces.ControllerArgs =
        com.pulumi.azurenative.devspaces.ControllerArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetContainerHostCredentialsBase64(
                targetContainerHostCredentialsBase64?.applyValue({ args0 ->
                    args0
                }),
            )
            .targetContainerHostResourceId(
                targetContainerHostResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ControllerArgs].
 */
@PulumiTagMarker
public class ControllerArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetContainerHostCredentialsBase64: Output<String>? = null

    private var targetContainerHostResourceId: Output<String>? = null

    /**
     * @param value Region where the Azure resource is located.
     */
    @JvmName("ytwmqlymdbphbvxr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("kpensgdosgtgpigo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Resource group to which the resource belongs.
     */
    @JvmName("ocsksksfssicspsu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Model representing SKU for Azure Dev Spaces Controller.
     */
    @JvmName("ovwassowubuknxbe")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Tags for the Azure resource.
     */
    @JvmName("rqbivjmsvsgobkxs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Credentials of the target container host (base64).
     */
    @JvmName("qkeqvhvirjlqjwfq")
    public suspend fun targetContainerHostCredentialsBase64(`value`: Output<String>) {
        this.targetContainerHostCredentialsBase64 = value
    }

    /**
     * @param value Resource ID of the target container host
     */
    @JvmName("dosddpmutbtqdsfj")
    public suspend fun targetContainerHostResourceId(`value`: Output<String>) {
        this.targetContainerHostResourceId = value
    }

    /**
     * @param value Region where the Azure resource is located.
     */
    @JvmName("fakurntkcwhoavbf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the resource.
     */
    @JvmName("whpdutticflgfdvc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Resource group to which the resource belongs.
     */
    @JvmName("basolblcqivsfeli")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Model representing SKU for Azure Dev Spaces Controller.
     */
    @JvmName("vsfyfmvxcvyaggwb")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Model representing SKU for Azure Dev Spaces Controller.
     */
    @JvmName("fvpfeaqlbbjfhoqv")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Tags for the Azure resource.
     */
    @JvmName("apkxykgfohfprejw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags for the Azure resource.
     */
    @JvmName("ccdxuokfvjofoepl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Credentials of the target container host (base64).
     */
    @JvmName("rjdbchpyixtqesjf")
    public suspend fun targetContainerHostCredentialsBase64(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetContainerHostCredentialsBase64 = mapped
    }

    /**
     * @param value Resource ID of the target container host
     */
    @JvmName("mjepckkewdcbwlur")
    public suspend fun targetContainerHostResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetContainerHostResourceId = mapped
    }

    internal fun build(): ControllerArgs = ControllerArgs(
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        targetContainerHostCredentialsBase64 = targetContainerHostCredentialsBase64,
        targetContainerHostResourceId = targetContainerHostResourceId,
    )
}
