@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devspaces.kotlin.inputs

import com.pulumi.azurenative.devspaces.inputs.SkuArgs.builder
import com.pulumi.azurenative.devspaces.kotlin.enums.SkuName
import com.pulumi.azurenative.devspaces.kotlin.enums.SkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model representing SKU for Azure Dev Spaces Controller.
 * @property name The name of the SKU for Azure Dev Spaces Controller.
 * @property tier The tier of the SKU for Azure Dev Spaces Controller.
 */
public data class SkuArgs(
    public val name: Output<Either<String, SkuName>>,
    public val tier: Output<Either<String, SkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devspaces.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.devspaces.inputs.SkuArgs =
        com.pulumi.azurenative.devspaces.inputs.SkuArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<Either<String, SkuName>>? = null

    private var tier: Output<Either<String, SkuTier>>? = null

    /**
     * @param value The name of the SKU for Azure Dev Spaces Controller.
     */
    @JvmName("yipnkxuoolwbcebo")
    public suspend fun name(`value`: Output<Either<String, SkuName>>) {
        this.name = value
    }

    /**
     * @param value The tier of the SKU for Azure Dev Spaces Controller.
     */
    @JvmName("otgbtagewbwjeibl")
    public suspend fun tier(`value`: Output<Either<String, SkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The name of the SKU for Azure Dev Spaces Controller.
     */
    @JvmName("bnnsvtcsepfwvxuf")
    public suspend fun name(`value`: Either<String, SkuName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU for Azure Dev Spaces Controller.
     */
    @JvmName("mqbrjtfihdxhdmli")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU for Azure Dev Spaces Controller.
     */
    @JvmName("ruppluhcwmpuabwv")
    public fun name(`value`: SkuName) {
        val toBeMapped = Either.ofRight<String, SkuName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tier of the SKU for Azure Dev Spaces Controller.
     */
    @JvmName("wbgfqkadyajsosnj")
    public suspend fun tier(`value`: Either<String, SkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the SKU for Azure Dev Spaces Controller.
     */
    @JvmName("shbuylaqmqttbpdc")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The tier of the SKU for Azure Dev Spaces Controller.
     */
    @JvmName("dgojsjumnmeldelf")
    public fun tier(`value`: SkuTier) {
        val toBeMapped = Either.ofRight<String, SkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
