@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.CustomImageArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.CustomImagePropertiesCustomArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.CustomImagePropertiesCustomArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.CustomImagePropertiesFromPlanArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.CustomImagePropertiesFromPlanArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.CustomImagePropertiesFromVmArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.CustomImagePropertiesFromVmArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.DataDiskStorageTypeInfoArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.DataDiskStorageTypeInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A custom image.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### CustomImages_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customImage = new AzureNative.DevTestLab.CustomImage("customImage", new()
 *     {
 *         Description = "My Custom Image",
 *         LabName = "{labName}",
 *         Name = "{customImageName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         Vm = new AzureNative.DevTestLab.Inputs.CustomImagePropertiesFromVmArgs
 *         {
 *             LinuxOsInfo = new AzureNative.DevTestLab.Inputs.LinuxOsInfoArgs
 *             {
 *                 LinuxOsState = "NonDeprovisioned",
 *             },
 *             SourceVmId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/{vmName}",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewCustomImage(ctx, "customImage", &devtestlab.CustomImageArgs{
 * 			Description:       pulumi.String("My Custom Image"),
 * 			LabName:           pulumi.String("{labName}"),
 * 			Name:              pulumi.String("{customImageName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			Vm: devtestlab.CustomImagePropertiesFromVmResponse{
 * 				LinuxOsInfo: &devtestlab.LinuxOsInfoArgs{
 * 					LinuxOsState: pulumi.String("NonDeprovisioned"),
 * 				},
 * 				SourceVmId: pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/{vmName}"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.CustomImage;
 * import com.pulumi.azurenative.devtestlab.CustomImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customImage = new CustomImage("customImage", CustomImageArgs.builder()
 *             .description("My Custom Image")
 *             .labName("{labName}")
 *             .name("{customImageName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .vm(Map.ofEntries(
 *                 Map.entry("linuxOsInfo", Map.of("linuxOsState", "NonDeprovisioned")),
 *                 Map.entry("sourceVmId", "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/{vmName}")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:CustomImage {customImageName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/customimages/{name}
 * ```
 * @property author The author of the custom image.
 * @property customImagePlan Storage information about the plan related to this custom image
 * @property dataDiskStorageInfo Storage information about the data disks present in the custom image
 * @property description The description of the custom image.
 * @property isPlanAuthorized Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property managedImageId The Managed Image Id backing the custom image.
 * @property managedSnapshotId The Managed Snapshot Id backing the custom image.
 * @property name The name of the custom image.
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags of the resource.
 * @property vhd The VHD from which the image is to be created.
 * @property vm The virtual machine from which the image is to be created.
 */
public data class CustomImageArgs(
    public val author: Output<String>? = null,
    public val customImagePlan: Output<CustomImagePropertiesFromPlanArgs>? = null,
    public val dataDiskStorageInfo: Output<List<DataDiskStorageTypeInfoArgs>>? = null,
    public val description: Output<String>? = null,
    public val isPlanAuthorized: Output<Boolean>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedImageId: Output<String>? = null,
    public val managedSnapshotId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vhd: Output<CustomImagePropertiesCustomArgs>? = null,
    public val vm: Output<CustomImagePropertiesFromVmArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.CustomImageArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.CustomImageArgs =
        com.pulumi.azurenative.devtestlab.CustomImageArgs.builder()
            .author(author?.applyValue({ args0 -> args0 }))
            .customImagePlan(customImagePlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataDiskStorageInfo(
                dataDiskStorageInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .isPlanAuthorized(isPlanAuthorized?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedImageId(managedImageId?.applyValue({ args0 -> args0 }))
            .managedSnapshotId(managedSnapshotId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vhd(vhd?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vm(vm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomImageArgs].
 */
@PulumiTagMarker
public class CustomImageArgsBuilder internal constructor() {
    private var author: Output<String>? = null

    private var customImagePlan: Output<CustomImagePropertiesFromPlanArgs>? = null

    private var dataDiskStorageInfo: Output<List<DataDiskStorageTypeInfoArgs>>? = null

    private var description: Output<String>? = null

    private var isPlanAuthorized: Output<Boolean>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var managedImageId: Output<String>? = null

    private var managedSnapshotId: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vhd: Output<CustomImagePropertiesCustomArgs>? = null

    private var vm: Output<CustomImagePropertiesFromVmArgs>? = null

    /**
     * @param value The author of the custom image.
     */
    @JvmName("lrajfnaxkxkiqapr")
    public suspend fun author(`value`: Output<String>) {
        this.author = value
    }

    /**
     * @param value Storage information about the plan related to this custom image
     */
    @JvmName("ffcwqunokgvvbtqa")
    public suspend fun customImagePlan(`value`: Output<CustomImagePropertiesFromPlanArgs>) {
        this.customImagePlan = value
    }

    /**
     * @param value Storage information about the data disks present in the custom image
     */
    @JvmName("fasiwpkfitefuvuh")
    public suspend fun dataDiskStorageInfo(`value`: Output<List<DataDiskStorageTypeInfoArgs>>) {
        this.dataDiskStorageInfo = value
    }

    @JvmName("xbjxlpqqbxpcxwgx")
    public suspend fun dataDiskStorageInfo(vararg values: Output<DataDiskStorageTypeInfoArgs>) {
        this.dataDiskStorageInfo = Output.all(values.asList())
    }

    /**
     * @param values Storage information about the data disks present in the custom image
     */
    @JvmName("dehfyxyawtmwqrdr")
    public suspend fun dataDiskStorageInfo(values: List<Output<DataDiskStorageTypeInfoArgs>>) {
        this.dataDiskStorageInfo = Output.all(values)
    }

    /**
     * @param value The description of the custom image.
     */
    @JvmName("qcwsunpeiimwqogn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment
     */
    @JvmName("ifmfndcydkqrblro")
    public suspend fun isPlanAuthorized(`value`: Output<Boolean>) {
        this.isPlanAuthorized = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("mbeqdhqxcpuorkuk")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("ynqtqsrvcwxfpmrh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The Managed Image Id backing the custom image.
     */
    @JvmName("ovesllyoerwlwpeu")
    public suspend fun managedImageId(`value`: Output<String>) {
        this.managedImageId = value
    }

    /**
     * @param value The Managed Snapshot Id backing the custom image.
     */
    @JvmName("lwmcavmupvbbxvmu")
    public suspend fun managedSnapshotId(`value`: Output<String>) {
        this.managedSnapshotId = value
    }

    /**
     * @param value The name of the custom image.
     */
    @JvmName("qffjmhrfrkaiylfx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pxkqaerivclgvilx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("dgvokoumcgfunhab")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VHD from which the image is to be created.
     */
    @JvmName("hhuswiggurodyqke")
    public suspend fun vhd(`value`: Output<CustomImagePropertiesCustomArgs>) {
        this.vhd = value
    }

    /**
     * @param value The virtual machine from which the image is to be created.
     */
    @JvmName("cbopeiwtxapftenf")
    public suspend fun vm(`value`: Output<CustomImagePropertiesFromVmArgs>) {
        this.vm = value
    }

    /**
     * @param value The author of the custom image.
     */
    @JvmName("pvddpfpdwcdpihlp")
    public suspend fun author(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.author = mapped
    }

    /**
     * @param value Storage information about the plan related to this custom image
     */
    @JvmName("gnmxmrvuwxmwphea")
    public suspend fun customImagePlan(`value`: CustomImagePropertiesFromPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImagePlan = mapped
    }

    /**
     * @param argument Storage information about the plan related to this custom image
     */
    @JvmName("jqjycurrpqqgmmdu")
    public suspend
    fun customImagePlan(argument: suspend CustomImagePropertiesFromPlanArgsBuilder.() -> Unit) {
        val toBeMapped = CustomImagePropertiesFromPlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customImagePlan = mapped
    }

    /**
     * @param value Storage information about the data disks present in the custom image
     */
    @JvmName("omttjdodpwqtkanl")
    public suspend fun dataDiskStorageInfo(`value`: List<DataDiskStorageTypeInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskStorageInfo = mapped
    }

    /**
     * @param argument Storage information about the data disks present in the custom image
     */
    @JvmName("cyqewmgwyyqjxlff")
    public suspend
    fun dataDiskStorageInfo(argument: List<suspend DataDiskStorageTypeInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataDiskStorageTypeInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskStorageInfo = mapped
    }

    /**
     * @param argument Storage information about the data disks present in the custom image
     */
    @JvmName("dgelsfxvburslnya")
    public suspend fun dataDiskStorageInfo(
        vararg
        argument: suspend DataDiskStorageTypeInfoArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataDiskStorageTypeInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskStorageInfo = mapped
    }

    /**
     * @param argument Storage information about the data disks present in the custom image
     */
    @JvmName("cynumpfxsbqvucrf")
    public suspend
    fun dataDiskStorageInfo(argument: suspend DataDiskStorageTypeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataDiskStorageTypeInfoArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDiskStorageInfo = mapped
    }

    /**
     * @param values Storage information about the data disks present in the custom image
     */
    @JvmName("oevawbbxqeovging")
    public suspend fun dataDiskStorageInfo(vararg values: DataDiskStorageTypeInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDiskStorageInfo = mapped
    }

    /**
     * @param value The description of the custom image.
     */
    @JvmName("kgyyrxaagkxplmfg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether or not the custom images underlying offer/plan has been enabled for programmatic deployment
     */
    @JvmName("ayiaombwabylaosr")
    public suspend fun isPlanAuthorized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPlanAuthorized = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("oipqjvvyssptrnih")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("xclyffdbchxrtwuu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The Managed Image Id backing the custom image.
     */
    @JvmName("fiaiagjsfoftjcaq")
    public suspend fun managedImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedImageId = mapped
    }

    /**
     * @param value The Managed Snapshot Id backing the custom image.
     */
    @JvmName("nagwdsynqbxpaxkv")
    public suspend fun managedSnapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedSnapshotId = mapped
    }

    /**
     * @param value The name of the custom image.
     */
    @JvmName("hhrekkfwixbngmrt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wccuqppdgyotlgsc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("fuaaombmiygnvabe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("edqijemsftbrmhmj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VHD from which the image is to be created.
     */
    @JvmName("hwxkledsufoogutl")
    public suspend fun vhd(`value`: CustomImagePropertiesCustomArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vhd = mapped
    }

    /**
     * @param argument The VHD from which the image is to be created.
     */
    @JvmName("bcbvcvbvkuumjaex")
    public suspend fun vhd(argument: suspend CustomImagePropertiesCustomArgsBuilder.() -> Unit) {
        val toBeMapped = CustomImagePropertiesCustomArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vhd = mapped
    }

    /**
     * @param value The virtual machine from which the image is to be created.
     */
    @JvmName("ljpuwldrpdarutnl")
    public suspend fun vm(`value`: CustomImagePropertiesFromVmArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vm = mapped
    }

    /**
     * @param argument The virtual machine from which the image is to be created.
     */
    @JvmName("dinpxrcatuxorqxl")
    public suspend fun vm(argument: suspend CustomImagePropertiesFromVmArgsBuilder.() -> Unit) {
        val toBeMapped = CustomImagePropertiesFromVmArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vm = mapped
    }

    internal fun build(): CustomImageArgs = CustomImageArgs(
        author = author,
        customImagePlan = customImagePlan,
        dataDiskStorageInfo = dataDiskStorageInfo,
        description = description,
        isPlanAuthorized = isPlanAuthorized,
        labName = labName,
        location = location,
        managedImageId = managedImageId,
        managedSnapshotId = managedSnapshotId,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vhd = vhd,
        vm = vm,
    )
}
