@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.DiskArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.StorageType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Disk.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Disks_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disk = new AzureNative.DevTestLab.Disk("disk", new()
 *     {
 *         DiskSizeGiB = 1023,
 *         DiskType = "Standard",
 *         LabName = "{labName}",
 *         LeasedByLabVmId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/vmName",
 *         Name = "{diskName}",
 *         ResourceGroupName = "resourceGroupName",
 *         UserName = "{userId}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewDisk(ctx, "disk", &devtestlab.DiskArgs{
 * 			DiskSizeGiB:       pulumi.Int(1023),
 * 			DiskType:          pulumi.String("Standard"),
 * 			LabName:           pulumi.String("{labName}"),
 * 			LeasedByLabVmId:   pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/vmName"),
 * 			Name:              pulumi.String("{diskName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			UserName:          pulumi.String("{userId}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Disk;
 * import com.pulumi.azurenative.devtestlab.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disk = new Disk("disk", DiskArgs.builder()
 *             .diskSizeGiB(1023)
 *             .diskType("Standard")
 *             .labName("{labName}")
 *             .leasedByLabVmId("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualmachines/vmName")
 *             .name("{diskName}")
 *             .resourceGroupName("resourceGroupName")
 *             .userName("{userId}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Disk {diskName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}
 * ```
 * @property diskBlobName When backed by a blob, the name of the VHD blob without extension.
 * @property diskSizeGiB The size of the disk in Gibibytes.
 * @property diskType The storage type for the disk (i.e. Standard, Premium).
 * @property diskUri When backed by a blob, the URI of underlying blob.
 * @property hostCaching The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
 * @property labName The name of the lab.
 * @property leasedByLabVmId The resource ID of the VM to which this disk is leased.
 * @property location The location of the resource.
 * @property managedDiskId When backed by managed disk, this is the ID of the compute disk resource.
 * @property name The name of the disk.
 * @property resourceGroupName The name of the resource group.
 * @property storageAccountId When backed by a blob, the storage account where the blob is.
 * @property tags The tags of the resource.
 * @property userName The name of the user profile.
 */
public data class DiskArgs(
    public val diskBlobName: Output<String>? = null,
    public val diskSizeGiB: Output<Int>? = null,
    public val diskType: Output<Either<String, StorageType>>? = null,
    public val diskUri: Output<String>? = null,
    public val hostCaching: Output<String>? = null,
    public val labName: Output<String>? = null,
    public val leasedByLabVmId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedDiskId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storageAccountId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.DiskArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.DiskArgs =
        com.pulumi.azurenative.devtestlab.DiskArgs.builder()
            .diskBlobName(diskBlobName?.applyValue({ args0 -> args0 }))
            .diskSizeGiB(diskSizeGiB?.applyValue({ args0 -> args0 }))
            .diskType(
                diskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskUri(diskUri?.applyValue({ args0 -> args0 }))
            .hostCaching(hostCaching?.applyValue({ args0 -> args0 }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .leasedByLabVmId(leasedByLabVmId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedDiskId(managedDiskId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskArgs].
 */
@PulumiTagMarker
public class DiskArgsBuilder internal constructor() {
    private var diskBlobName: Output<String>? = null

    private var diskSizeGiB: Output<Int>? = null

    private var diskType: Output<Either<String, StorageType>>? = null

    private var diskUri: Output<String>? = null

    private var hostCaching: Output<String>? = null

    private var labName: Output<String>? = null

    private var leasedByLabVmId: Output<String>? = null

    private var location: Output<String>? = null

    private var managedDiskId: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    /**
     * @param value When backed by a blob, the name of the VHD blob without extension.
     */
    @JvmName("xqpbwvrulogrrcbr")
    public suspend fun diskBlobName(`value`: Output<String>) {
        this.diskBlobName = value
    }

    /**
     * @param value The size of the disk in Gibibytes.
     */
    @JvmName("qahsbeayvwlnefts")
    public suspend fun diskSizeGiB(`value`: Output<Int>) {
        this.diskSizeGiB = value
    }

    /**
     * @param value The storage type for the disk (i.e. Standard, Premium).
     */
    @JvmName("xjfhlljegdbmucui")
    public suspend fun diskType(`value`: Output<Either<String, StorageType>>) {
        this.diskType = value
    }

    /**
     * @param value When backed by a blob, the URI of underlying blob.
     */
    @JvmName("iliqwlpdqbwafjyt")
    public suspend fun diskUri(`value`: Output<String>) {
        this.diskUri = value
    }

    /**
     * @param value The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
     */
    @JvmName("jdnvajvcnajxwhwk")
    public suspend fun hostCaching(`value`: Output<String>) {
        this.hostCaching = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("wyukhmxmpbovnapa")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The resource ID of the VM to which this disk is leased.
     */
    @JvmName("ellacveqjmdoinjr")
    public suspend fun leasedByLabVmId(`value`: Output<String>) {
        this.leasedByLabVmId = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("reneryyllxjqfjkb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value When backed by managed disk, this is the ID of the compute disk resource.
     */
    @JvmName("bnmppmmmxvuoqamm")
    public suspend fun managedDiskId(`value`: Output<String>) {
        this.managedDiskId = value
    }

    /**
     * @param value The name of the disk.
     */
    @JvmName("qoqomsepgksmlhft")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sfrissxbneptnkyq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value When backed by a blob, the storage account where the blob is.
     */
    @JvmName("ilqisfxnukawvwul")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("soejvcgvixxeyxhi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("nfuhwvalaaktsmry")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value When backed by a blob, the name of the VHD blob without extension.
     */
    @JvmName("tvfdvhikikgkljhs")
    public suspend fun diskBlobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskBlobName = mapped
    }

    /**
     * @param value The size of the disk in Gibibytes.
     */
    @JvmName("tnxibdpgaqxrgtkg")
    public suspend fun diskSizeGiB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSizeGiB = mapped
    }

    /**
     * @param value The storage type for the disk (i.e. Standard, Premium).
     */
    @JvmName("qyqexgesgtccxorn")
    public suspend fun diskType(`value`: Either<String, StorageType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The storage type for the disk (i.e. Standard, Premium).
     */
    @JvmName("edtitglhrmgdykum")
    public fun diskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value The storage type for the disk (i.e. Standard, Premium).
     */
    @JvmName("imsadjcmqqgyhohu")
    public fun diskType(`value`: StorageType) {
        val toBeMapped = Either.ofRight<String, StorageType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value When backed by a blob, the URI of underlying blob.
     */
    @JvmName("agqaewosusgvrvyr")
    public suspend fun diskUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskUri = mapped
    }

    /**
     * @param value The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
     */
    @JvmName("mepmeedwovvkhqsh")
    public suspend fun hostCaching(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostCaching = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("qaseufqnvuyhnykb")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The resource ID of the VM to which this disk is leased.
     */
    @JvmName("ettbavvompluotft")
    public suspend fun leasedByLabVmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.leasedByLabVmId = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("gdbiqsutvsxsbuno")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value When backed by managed disk, this is the ID of the compute disk resource.
     */
    @JvmName("algldbatjukfhrap")
    public suspend fun managedDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedDiskId = mapped
    }

    /**
     * @param value The name of the disk.
     */
    @JvmName("ttsesfsxwgjinoby")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tffvohvfyomydqbg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value When backed by a blob, the storage account where the blob is.
     */
    @JvmName("bhadfckrapvwrvwo")
    public suspend fun storageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("tmkxuubljcgtxinl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("dgylsukcyumbevxr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("yhuceuryryispohj")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): DiskArgs = DiskArgs(
        diskBlobName = diskBlobName,
        diskSizeGiB = diskSizeGiB,
        diskType = diskType,
        diskUri = diskUri,
        hostCaching = hostCaching,
        labName = labName,
        leasedByLabVmId = leasedByLabVmId,
        location = location,
        managedDiskId = managedDiskId,
        name = name,
        resourceGroupName = resourceGroupName,
        storageAccountId = storageAccountId,
        tags = tags,
        userName = userName,
    )
}
