@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.LabAnnouncementPropertiesResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.LabSupportPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.devtestlab.kotlin.outputs.LabAnnouncementPropertiesResponse.Companion.toKotlin as labAnnouncementPropertiesResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.LabSupportPropertiesResponse.Companion.toKotlin as labSupportPropertiesResponseToKotlin

/**
 * Builder for [Lab].
 */
@PulumiTagMarker
public class LabResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LabArgs = LabArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LabArgsBuilder.() -> Unit) {
        val builder = LabArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Lab {
        val builtJavaResource = com.pulumi.azurenative.devtestlab.Lab(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Lab(builtJavaResource)
    }
}

/**
 * A lab.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Labs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lab = new AzureNative.DevTestLab.Lab("lab", new()
 *     {
 *         LabStorageType = "{Standard|Premium}",
 *         Location = "{location}",
 *         Name = "{labName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewLab(ctx, "lab", &devtestlab.LabArgs{
 * 			LabStorageType:    pulumi.String("{Standard|Premium}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{labName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.Lab;
 * import com.pulumi.azurenative.devtestlab.LabArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lab = new Lab("lab", LabArgs.builder()
 *             .labStorageType("{Standard|Premium}")
 *             .location("{location}")
 *             .name("{labName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:Lab {labName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{name}
 * ```
 */
public class Lab internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.Lab,
) : KotlinCustomResource(javaResource, LabMapper) {
    /**
     * The properties of any lab announcement associated with this lab
     */
    public val announcement: Output<LabAnnouncementPropertiesResponse>?
        get() = javaResource.announcement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    labAnnouncementPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The lab's artifact storage account.
     */
    public val artifactsStorageAccount: Output<String>
        get() = javaResource.artifactsStorageAccount().applyValue({ args0 -> args0 })

    /**
     * The creation date of the lab.
     */
    public val createdDate: Output<String>
        get() = javaResource.createdDate().applyValue({ args0 -> args0 })

    /**
     * The lab's default premium storage account.
     */
    public val defaultPremiumStorageAccount: Output<String>
        get() = javaResource.defaultPremiumStorageAccount().applyValue({ args0 -> args0 })

    /**
     * The lab's default storage account.
     */
    public val defaultStorageAccount: Output<String>
        get() = javaResource.defaultStorageAccount().applyValue({ args0 -> args0 })

    /**
     * The access rights to be granted to the user when provisioning an environment
     */
    public val environmentPermission: Output<String>?
        get() = javaResource.environmentPermission().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extended properties of the lab used for experimental features
     */
    public val extendedProperties: Output<Map<String, String>>?
        get() = javaResource.extendedProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Type of storage used by the lab. It can be either Premium or Standard. Default is Premium.
     */
    public val labStorageType: Output<String>?
        get() = javaResource.labStorageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The load balancer used to for lab VMs that use shared IP address.
     */
    public val loadBalancerId: Output<String>
        get() = javaResource.loadBalancerId().applyValue({ args0 -> args0 })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ordered list of artifact resource IDs that should be applied on all Linux VM creations by default, prior to the artifacts specified by the user.
     */
    public val mandatoryArtifactsResourceIdsLinux: Output<List<String>>?
        get() = javaResource.mandatoryArtifactsResourceIdsLinux().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * The ordered list of artifact resource IDs that should be applied on all Windows VM creations by default, prior to the artifacts specified by the user.
     */
    public val mandatoryArtifactsResourceIdsWindows: Output<List<String>>?
        get() = javaResource.mandatoryArtifactsResourceIdsWindows().applyValue({ args0 ->
            args0.map({ args0 -> args0.map({ args0 -> args0 }) }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Network Security Group attached to the lab VMs Network interfaces to restrict open ports.
     */
    public val networkSecurityGroupId: Output<String>
        get() = javaResource.networkSecurityGroupId().applyValue({ args0 -> args0 })

    /**
     * The lab's premium data disk storage account.
     */
    public val premiumDataDiskStorageAccount: Output<String>
        get() = javaResource.premiumDataDiskStorageAccount().applyValue({ args0 -> args0 })

    /**
     * The setting to enable usage of premium data disks.
     * When its value is 'Enabled', creation of standard or premium data disks is allowed.
     * When its value is 'Disabled', only creation of standard data disks is allowed.
     */
    public val premiumDataDisks: Output<String>?
        get() = javaResource.premiumDataDisks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The public IP address for the lab's load balancer.
     */
    public val publicIpId: Output<String>
        get() = javaResource.publicIpId().applyValue({ args0 -> args0 })

    /**
     * The properties of any lab support message associated with this lab
     */
    public val support: Output<LabSupportPropertiesResponse>?
        get() = javaResource.support().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    labSupportPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })

    /**
     * The lab's Key vault.
     */
    public val vaultName: Output<String>
        get() = javaResource.vaultName().applyValue({ args0 -> args0 })

    /**
     * The resource group in which all new lab virtual machines will be created. To let DevTest Labs manage resource group creation, set this value to null.
     */
    public val vmCreationResourceGroup: Output<String>
        get() = javaResource.vmCreationResourceGroup().applyValue({ args0 -> args0 })
}

public object LabMapper : ResourceMapper<Lab> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.Lab::class == javaResource::class

    override fun map(javaResource: Resource): Lab = Lab(
        javaResource as
            com.pulumi.azurenative.devtestlab.Lab,
    )
}

/**
 * @see [Lab].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Lab].
 */
public suspend fun lab(name: String, block: suspend LabResourceBuilder.() -> Unit): Lab {
    val builder = LabResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Lab].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lab(name: String): Lab {
    val builder = LabResourceBuilder()
    builder.name(name)
    return builder.build()
}
