@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.ServiceRunnerArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A container for a managed identity to execute DevTest lab services.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * ## Example Usage
 * ### ServiceRunners_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceRunner = new AzureNative.DevTestLab.ServiceRunner("serviceRunner", new()
 *     {
 *         Identity = new AzureNative.DevTestLab.Inputs.IdentityPropertiesArgs
 *         {
 *             ClientSecretUrl = "{identityClientSecretUrl}",
 *             PrincipalId = "{identityPrincipalId}",
 *             TenantId = "{identityTenantId}",
 *             Type = "{identityType}",
 *         },
 *         LabName = "{devtestlabName}",
 *         Location = "{location}",
 *         Name = "{servicerunnerName}",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewServiceRunner(ctx, "serviceRunner", &devtestlab.ServiceRunnerArgs{
 * 			Identity: &devtestlab.IdentityPropertiesArgs{
 * 				ClientSecretUrl: pulumi.String("{identityClientSecretUrl}"),
 * 				PrincipalId:     pulumi.String("{identityPrincipalId}"),
 * 				TenantId:        pulumi.String("{identityTenantId}"),
 * 				Type:            pulumi.String("{identityType}"),
 * 			},
 * 			LabName:           pulumi.String("{devtestlabName}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{servicerunnerName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.ServiceRunner;
 * import com.pulumi.azurenative.devtestlab.ServiceRunnerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceRunner = new ServiceRunner("serviceRunner", ServiceRunnerArgs.builder()
 *             .identity(Map.ofEntries(
 *                 Map.entry("clientSecretUrl", "{identityClientSecretUrl}"),
 *                 Map.entry("principalId", "{identityPrincipalId}"),
 *                 Map.entry("tenantId", "{identityTenantId}"),
 *                 Map.entry("type", "{identityType}")
 *             ))
 *             .labName("{devtestlabName}")
 *             .location("{location}")
 *             .name("{servicerunnerName}")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:ServiceRunner {serviceRunnerName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/servicerunners/{name}
 * ```
 * @property identity The identity of the resource.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the service runner.
 * @property resourceGroupName The name of the resource group.
 * @property tags The tags of the resource.
 */
public data class ServiceRunnerArgs(
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.ServiceRunnerArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.ServiceRunnerArgs =
        com.pulumi.azurenative.devtestlab.ServiceRunnerArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceRunnerArgs].
 */
@PulumiTagMarker
public class ServiceRunnerArgsBuilder internal constructor() {
    private var identity: Output<IdentityPropertiesArgs>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The identity of the resource.
     */
    @JvmName("yjnlyoptxscvewqe")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("sdbuqsesjkvquclb")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("vdvdfijjthjmvpkl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the service runner.
     */
    @JvmName("jidfmqjrcbgfcclm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("klpirvyiiyoebkyy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("lxqtqdwryodhssqn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("vuvehdhbxwywrmhw")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("bcpbompttwtcsxwu")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("hnaxetmaroqcabqd")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("qyevcibpudpbbruw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the service runner.
     */
    @JvmName("napgweejgkjgicor")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mtheeyifvdugoopp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("faggcpotvrktvraq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("jlgktbltuebrafqx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceRunnerArgs = ServiceRunnerArgs(
        identity = identity,
        labName = labName,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
