@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.UserArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.UserIdentityArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.UserIdentityArgsBuilder
import com.pulumi.azurenative.devtestlab.kotlin.inputs.UserSecretStoreArgs
import com.pulumi.azurenative.devtestlab.kotlin.inputs.UserSecretStoreArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Profile of a lab user.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### Users_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var user = new AzureNative.DevTestLab.User("user", new()
 *     {
 *         Identity = new AzureNative.DevTestLab.Inputs.UserIdentityArgs
 *         {
 *             AppId = "{appId}",
 *             ObjectId = "{objectId}",
 *             PrincipalId = "{principalId}",
 *             PrincipalName = "{principalName}",
 *             TenantId = "{tenantId}",
 *         },
 *         LabName = "{devtestlabName}",
 *         Location = "{location}",
 *         Name = "{userName}",
 *         ResourceGroupName = "resourceGroupName",
 *         SecretStore = new AzureNative.DevTestLab.Inputs.UserSecretStoreArgs
 *         {
 *             KeyVaultId = "{keyVaultId}",
 *             KeyVaultUri = "{keyVaultUri}",
 *         },
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewUser(ctx, "user", &devtestlab.UserArgs{
 * 			Identity: &devtestlab.UserIdentityArgs{
 * 				AppId:         pulumi.String("{appId}"),
 * 				ObjectId:      pulumi.String("{objectId}"),
 * 				PrincipalId:   pulumi.String("{principalId}"),
 * 				PrincipalName: pulumi.String("{principalName}"),
 * 				TenantId:      pulumi.String("{tenantId}"),
 * 			},
 * 			LabName:           pulumi.String("{devtestlabName}"),
 * 			Location:          pulumi.String("{location}"),
 * 			Name:              pulumi.String("{userName}"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			SecretStore: &devtestlab.UserSecretStoreArgs{
 * 				KeyVaultId:  pulumi.String("{keyVaultId}"),
 * 				KeyVaultUri: pulumi.String("{keyVaultUri}"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.User;
 * import com.pulumi.azurenative.devtestlab.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var user = new User("user", UserArgs.builder()
 *             .identity(Map.ofEntries(
 *                 Map.entry("appId", "{appId}"),
 *                 Map.entry("objectId", "{objectId}"),
 *                 Map.entry("principalId", "{principalId}"),
 *                 Map.entry("principalName", "{principalName}"),
 *                 Map.entry("tenantId", "{tenantId}")
 *             ))
 *             .labName("{devtestlabName}")
 *             .location("{location}")
 *             .name("{userName}")
 *             .resourceGroupName("resourceGroupName")
 *             .secretStore(Map.ofEntries(
 *                 Map.entry("keyVaultId", "{keyVaultId}"),
 *                 Map.entry("keyVaultUri", "{keyVaultUri}")
 *             ))
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:User {userName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{name}
 * ```
 * @property identity The identity of the user.
 * @property labName The name of the lab.
 * @property location The location of the resource.
 * @property name The name of the user profile.
 * @property resourceGroupName The name of the resource group.
 * @property secretStore The secret store of the user.
 * @property tags The tags of the resource.
 */
public data class UserArgs(
    public val identity: Output<UserIdentityArgs>? = null,
    public val labName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secretStore: Output<UserSecretStoreArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.UserArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.UserArgs =
        com.pulumi.azurenative.devtestlab.UserArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labName(labName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secretStore(secretStore?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var identity: Output<UserIdentityArgs>? = null

    private var labName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var secretStore: Output<UserSecretStoreArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The identity of the user.
     */
    @JvmName("oheqtocfvnmawetd")
    public suspend fun identity(`value`: Output<UserIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("wlwkgsjdpadywuav")
    public suspend fun labName(`value`: Output<String>) {
        this.labName = value
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("njmctftbvxcxavhu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("uuwirqxrvctaextg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("yeiilhmwabklgaip")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The secret store of the user.
     */
    @JvmName("ojfskksuidxaswun")
    public suspend fun secretStore(`value`: Output<UserSecretStoreArgs>) {
        this.secretStore = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("mkhevdiqluwewuqc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The identity of the user.
     */
    @JvmName("efejjcdamxassysn")
    public suspend fun identity(`value`: UserIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the user.
     */
    @JvmName("ukebawvukrlurtsb")
    public suspend fun identity(argument: suspend UserIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = UserIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name of the lab.
     */
    @JvmName("ucmtteorbnvcwvsv")
    public suspend fun labName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labName = mapped
    }

    /**
     * @param value The location of the resource.
     */
    @JvmName("gcuhyhklfhoujchw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the user profile.
     */
    @JvmName("lsnjuotawvmcaqmf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vvgmrusqvhortqrx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The secret store of the user.
     */
    @JvmName("asedrpbhcdphwugn")
    public suspend fun secretStore(`value`: UserSecretStoreArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStore = mapped
    }

    /**
     * @param argument The secret store of the user.
     */
    @JvmName("qawvonavybdwumxd")
    public suspend fun secretStore(argument: suspend UserSecretStoreArgsBuilder.() -> Unit) {
        val toBeMapped = UserSecretStoreArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretStore = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("yainxpghfhgbxyqq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("uidgcndseifhntkq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        identity = identity,
        labName = labName,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        secretStore = secretStore,
        tags = tags,
    )
}
