@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin

import com.pulumi.azurenative.devtestlab.kotlin.outputs.ApplicableScheduleResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ArtifactDeploymentStatusPropertiesResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ArtifactInstallPropertiesResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ComputeVmPropertiesResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.DataDiskPropertiesResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GalleryImageReferenceResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.NetworkInterfacePropertiesResponse
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ScheduleCreationParameterResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ApplicableScheduleResponse.Companion.toKotlin as applicableScheduleResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ArtifactDeploymentStatusPropertiesResponse.Companion.toKotlin as artifactDeploymentStatusPropertiesResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ArtifactInstallPropertiesResponse.Companion.toKotlin as artifactInstallPropertiesResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ComputeVmPropertiesResponse.Companion.toKotlin as computeVmPropertiesResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.DataDiskPropertiesResponse.Companion.toKotlin as dataDiskPropertiesResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.GalleryImageReferenceResponse.Companion.toKotlin as galleryImageReferenceResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.NetworkInterfacePropertiesResponse.Companion.toKotlin as networkInterfacePropertiesResponseToKotlin
import com.pulumi.azurenative.devtestlab.kotlin.outputs.ScheduleCreationParameterResponse.Companion.toKotlin as scheduleCreationParameterResponseToKotlin

/**
 * Builder for [VirtualMachine].
 */
@PulumiTagMarker
public class VirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineArgs = VirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineArgsBuilder.() -> Unit) {
        val builder = VirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualMachine {
        val builtJavaResource =
            com.pulumi.azurenative.devtestlab.VirtualMachine(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachine(builtJavaResource)
    }
}

/**
 * A virtual machine.
 * Azure REST API version: 2018-09-15. Prior API version in Azure Native 1.x: 2018-09-15.
 * Other available API versions: 2016-05-15.
 * ## Example Usage
 * ### VirtualMachines_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachine = new AzureNative.DevTestLab.VirtualMachine("virtualMachine", new()
 *     {
 *         AllowClaim = true,
 *         DisallowPublicIpAddress = true,
 *         GalleryImageReference = new AzureNative.DevTestLab.Inputs.GalleryImageReferenceArgs
 *         {
 *             Offer = "UbuntuServer",
 *             OsType = "Linux",
 *             Publisher = "Canonical",
 *             Sku = "16.04-LTS",
 *             Version = "Latest",
 *         },
 *         LabName = "{labName}",
 *         LabSubnetName = "{virtualNetworkName}Subnet",
 *         LabVirtualNetworkId = "/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualnetworks/{virtualNetworkName}",
 *         Location = "{location}",
 *         Name = "{vmName}",
 *         Password = "{userPassword}",
 *         ResourceGroupName = "resourceGroupName",
 *         Size = "Standard_A2_v2",
 *         StorageType = "Standard",
 *         Tags =
 *         {
 *             { "tagName1", "tagValue1" },
 *         },
 *         UserName = "{userName}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devtestlab/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devtestlab.NewVirtualMachine(ctx, "virtualMachine", &devtestlab.VirtualMachineArgs{
 * 			AllowClaim:              pulumi.Bool(true),
 * 			DisallowPublicIpAddress: pulumi.Bool(true),
 * 			GalleryImageReference: &devtestlab.GalleryImageReferenceArgs{
 * 				Offer:     pulumi.String("UbuntuServer"),
 * 				OsType:    pulumi.String("Linux"),
 * 				Publisher: pulumi.String("Canonical"),
 * 				Sku:       pulumi.String("16.04-LTS"),
 * 				Version:   pulumi.String("Latest"),
 * 			},
 * 			LabName:             pulumi.String("{labName}"),
 * 			LabSubnetName:       pulumi.String("{virtualNetworkName}Subnet"),
 * 			LabVirtualNetworkId: pulumi.String("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualnetworks/{virtualNetworkName}"),
 * 			Location:            pulumi.String("{location}"),
 * 			Name:                pulumi.String("{vmName}"),
 * 			Password:            pulumi.String("{userPassword}"),
 * 			ResourceGroupName:   pulumi.String("resourceGroupName"),
 * 			Size:                pulumi.String("Standard_A2_v2"),
 * 			StorageType:         pulumi.String("Standard"),
 * 			Tags: pulumi.StringMap{
 * 				"tagName1": pulumi.String("tagValue1"),
 * 			},
 * 			UserName: pulumi.String("{userName}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devtestlab.VirtualMachine;
 * import com.pulumi.azurenative.devtestlab.VirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachine = new VirtualMachine("virtualMachine", VirtualMachineArgs.builder()
 *             .allowClaim(true)
 *             .disallowPublicIpAddress(true)
 *             .galleryImageReference(Map.ofEntries(
 *                 Map.entry("offer", "UbuntuServer"),
 *                 Map.entry("osType", "Linux"),
 *                 Map.entry("publisher", "Canonical"),
 *                 Map.entry("sku", "16.04-LTS"),
 *                 Map.entry("version", "Latest")
 *             ))
 *             .labName("{labName}")
 *             .labSubnetName("{virtualNetworkName}Subnet")
 *             .labVirtualNetworkId("/subscriptions/{subscriptionId}/resourcegroups/resourceGroupName/providers/microsoft.devtestlab/labs/{labName}/virtualnetworks/{virtualNetworkName}")
 *             .location("{location}")
 *             .name("{vmName}")
 *             .password("{userPassword}")
 *             .resourceGroupName("resourceGroupName")
 *             .size("Standard_A2_v2")
 *             .storageType("Standard")
 *             .tags(Map.of("tagName1", "tagValue1"))
 *             .userName("{userName}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devtestlab:VirtualMachine {vmName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/virtualmachines/{name}
 * ```
 */
public class VirtualMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.devtestlab.VirtualMachine,
) : KotlinCustomResource(javaResource, VirtualMachineMapper) {
    /**
     * Indicates whether another user can take ownership of the virtual machine
     */
    public val allowClaim: Output<Boolean>?
        get() = javaResource.allowClaim().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The applicable schedule for the virtual machine.
     */
    public val applicableSchedule: Output<ApplicableScheduleResponse>
        get() = javaResource.applicableSchedule().applyValue({ args0 ->
            args0.let({ args0 ->
                applicableScheduleResponseToKotlin(args0)
            })
        })

    /**
     * The artifact deployment status for the virtual machine.
     */
    public val artifactDeploymentStatus: Output<ArtifactDeploymentStatusPropertiesResponse>
        get() = javaResource.artifactDeploymentStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                artifactDeploymentStatusPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The artifacts to be installed on the virtual machine.
     */
    public val artifacts: Output<List<ArtifactInstallPropertiesResponse>>?
        get() = javaResource.artifacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> artifactInstallPropertiesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The resource identifier (Microsoft.Compute) of the virtual machine.
     */
    public val computeId: Output<String>
        get() = javaResource.computeId().applyValue({ args0 -> args0 })

    /**
     * The compute virtual machine properties.
     */
    public val computeVm: Output<ComputeVmPropertiesResponse>
        get() = javaResource.computeVm().applyValue({ args0 ->
            args0.let({ args0 ->
                computeVmPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The email address of creator of the virtual machine.
     */
    public val createdByUser: Output<String>
        get() = javaResource.createdByUser().applyValue({ args0 -> args0 })

    /**
     * The object identifier of the creator of the virtual machine.
     */
    public val createdByUserId: Output<String>
        get() = javaResource.createdByUserId().applyValue({ args0 -> args0 })

    /**
     * The creation date of the virtual machine.
     */
    public val createdDate: Output<String>?
        get() = javaResource.createdDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The custom image identifier of the virtual machine.
     */
    public val customImageId: Output<String>?
        get() = javaResource.customImageId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * New or existing data disks to attach to the virtual machine after creation
     */
    public val dataDiskParameters: Output<List<DataDiskPropertiesResponse>>?
        get() = javaResource.dataDiskParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dataDiskPropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Indicates whether the virtual machine is to be created without a public IP address.
     */
    public val disallowPublicIpAddress: Output<Boolean>?
        get() = javaResource.disallowPublicIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the environment that contains this virtual machine, if any.
     */
    public val environmentId: Output<String>?
        get() = javaResource.environmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The expiration date for VM.
     */
    public val expirationDate: Output<String>?
        get() = javaResource.expirationDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The fully-qualified domain name of the virtual machine.
     */
    public val fqdn: Output<String>
        get() = javaResource.fqdn().applyValue({ args0 -> args0 })

    /**
     * The Microsoft Azure Marketplace image reference of the virtual machine.
     */
    public val galleryImageReference: Output<GalleryImageReferenceResponse>?
        get() = javaResource.galleryImageReference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> galleryImageReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Indicates whether this virtual machine uses an SSH key for authentication.
     */
    public val isAuthenticationWithSshKey: Output<Boolean>?
        get() = javaResource.isAuthenticationWithSshKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The lab subnet name of the virtual machine.
     */
    public val labSubnetName: Output<String>?
        get() = javaResource.labSubnetName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The lab virtual network identifier of the virtual machine.
     */
    public val labVirtualNetworkId: Output<String>?
        get() = javaResource.labVirtualNetworkId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last known compute power state captured in DTL
     */
    public val lastKnownPowerState: Output<String>
        get() = javaResource.lastKnownPowerState().applyValue({ args0 -> args0 })

    /**
     * The location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The network interface properties.
     */
    public val networkInterface: Output<NetworkInterfacePropertiesResponse>?
        get() = javaResource.networkInterface().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfacePropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The notes of the virtual machine.
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The OS type of the virtual machine.
     */
    public val osType: Output<String>
        get() = javaResource.osType().applyValue({ args0 -> args0 })

    /**
     * The object identifier of the owner of the virtual machine.
     */
    public val ownerObjectId: Output<String>?
        get() = javaResource.ownerObjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The user principal name of the virtual machine owner.
     */
    public val ownerUserPrincipalName: Output<String>?
        get() = javaResource.ownerUserPrincipalName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The password of the virtual machine administrator.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The id of the plan associated with the virtual machine image
     */
    public val planId: Output<String>?
        get() = javaResource.planId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning status of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Virtual Machine schedules to be created
     */
    public val scheduleParameters: Output<List<ScheduleCreationParameterResponse>>?
        get() = javaResource.scheduleParameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        scheduleCreationParameterResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The size of the virtual machine.
     */
    public val size: Output<String>?
        get() = javaResource.size().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The SSH key of the virtual machine administrator.
     */
    public val sshKey: Output<String>?
        get() = javaResource.sshKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Storage type to use for virtual machine (i.e. Standard, Premium).
     */
    public val storageType: Output<String>?
        get() = javaResource.storageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The unique immutable identifier of a resource (Guid).
     */
    public val uniqueIdentifier: Output<String>
        get() = javaResource.uniqueIdentifier().applyValue({ args0 -> args0 })

    /**
     * The user name of the virtual machine.
     */
    public val userName: Output<String>?
        get() = javaResource.userName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Tells source of creation of lab virtual machine. Output property only.
     */
    public val virtualMachineCreationSource: Output<String>
        get() = javaResource.virtualMachineCreationSource().applyValue({ args0 -> args0 })
}

public object VirtualMachineMapper : ResourceMapper<VirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devtestlab.VirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachine = VirtualMachine(
        javaResource as
            com.pulumi.azurenative.devtestlab.VirtualMachine,
    )
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachine].
 */
public suspend fun virtualMachine(
    name: String,
    block: suspend VirtualMachineResourceBuilder.() -> Unit,
): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachine(name: String): VirtualMachine {
    val builder = VirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
