@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.ArtifactInstallPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of an artifact.
 * @property artifactId The artifact's identifier.
 * @property artifactTitle The artifact's title.
 * @property deploymentStatusMessage The status message from the deployment.
 * @property installTime The time that the artifact starts to install on the virtual machine.
 * @property parameters The parameters of the artifact.
 * @property status The status of the artifact.
 * @property vmExtensionStatusMessage The status message from the virtual machine extension.
 */
public data class ArtifactInstallPropertiesArgs(
    public val artifactId: Output<String>? = null,
    public val artifactTitle: Output<String>? = null,
    public val deploymentStatusMessage: Output<String>? = null,
    public val installTime: Output<String>? = null,
    public val parameters: Output<List<ArtifactParameterPropertiesArgs>>? = null,
    public val status: Output<String>? = null,
    public val vmExtensionStatusMessage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.ArtifactInstallPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.ArtifactInstallPropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.ArtifactInstallPropertiesArgs.builder()
            .artifactId(artifactId?.applyValue({ args0 -> args0 }))
            .artifactTitle(artifactTitle?.applyValue({ args0 -> args0 }))
            .deploymentStatusMessage(deploymentStatusMessage?.applyValue({ args0 -> args0 }))
            .installTime(installTime?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .status(status?.applyValue({ args0 -> args0 }))
            .vmExtensionStatusMessage(vmExtensionStatusMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArtifactInstallPropertiesArgs].
 */
@PulumiTagMarker
public class ArtifactInstallPropertiesArgsBuilder internal constructor() {
    private var artifactId: Output<String>? = null

    private var artifactTitle: Output<String>? = null

    private var deploymentStatusMessage: Output<String>? = null

    private var installTime: Output<String>? = null

    private var parameters: Output<List<ArtifactParameterPropertiesArgs>>? = null

    private var status: Output<String>? = null

    private var vmExtensionStatusMessage: Output<String>? = null

    /**
     * @param value The artifact's identifier.
     */
    @JvmName("suknlgytmrqrvtav")
    public suspend fun artifactId(`value`: Output<String>) {
        this.artifactId = value
    }

    /**
     * @param value The artifact's title.
     */
    @JvmName("robnnofjnsdwsrek")
    public suspend fun artifactTitle(`value`: Output<String>) {
        this.artifactTitle = value
    }

    /**
     * @param value The status message from the deployment.
     */
    @JvmName("tcpvqioxligtqihx")
    public suspend fun deploymentStatusMessage(`value`: Output<String>) {
        this.deploymentStatusMessage = value
    }

    /**
     * @param value The time that the artifact starts to install on the virtual machine.
     */
    @JvmName("jwmnchfokjqmvfsl")
    public suspend fun installTime(`value`: Output<String>) {
        this.installTime = value
    }

    /**
     * @param value The parameters of the artifact.
     */
    @JvmName("diwfthsngdecrmba")
    public suspend fun parameters(`value`: Output<List<ArtifactParameterPropertiesArgs>>) {
        this.parameters = value
    }

    @JvmName("uggxykpxkepairvr")
    public suspend fun parameters(vararg values: Output<ArtifactParameterPropertiesArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The parameters of the artifact.
     */
    @JvmName("chspjimpwhxsmeqn")
    public suspend fun parameters(values: List<Output<ArtifactParameterPropertiesArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The status of the artifact.
     */
    @JvmName("mwvcluldntnqofsx")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The status message from the virtual machine extension.
     */
    @JvmName("khabtyltqyyvyhro")
    public suspend fun vmExtensionStatusMessage(`value`: Output<String>) {
        this.vmExtensionStatusMessage = value
    }

    /**
     * @param value The artifact's identifier.
     */
    @JvmName("xqxxenyvkxgmtpys")
    public suspend fun artifactId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactId = mapped
    }

    /**
     * @param value The artifact's title.
     */
    @JvmName("nnhhdlpnuavyyqks")
    public suspend fun artifactTitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactTitle = mapped
    }

    /**
     * @param value The status message from the deployment.
     */
    @JvmName("uhprueobvpyxpxtw")
    public suspend fun deploymentStatusMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentStatusMessage = mapped
    }

    /**
     * @param value The time that the artifact starts to install on the virtual machine.
     */
    @JvmName("djccfflljocbjeix")
    public suspend fun installTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installTime = mapped
    }

    /**
     * @param value The parameters of the artifact.
     */
    @JvmName("nqgrxuxldtjyhvgs")
    public suspend fun parameters(`value`: List<ArtifactParameterPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the artifact.
     */
    @JvmName("fsambsmmgetilcuc")
    public suspend
    fun parameters(argument: List<suspend ArtifactParameterPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArtifactParameterPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the artifact.
     */
    @JvmName("tgbifpishidvqgje")
    public suspend fun parameters(
        vararg
        argument: suspend ArtifactParameterPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ArtifactParameterPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The parameters of the artifact.
     */
    @JvmName("vmtxiqdcokoeopop")
    public suspend
    fun parameters(argument: suspend ArtifactParameterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ArtifactParameterPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameters of the artifact.
     */
    @JvmName("hbhwvolplenufewg")
    public suspend fun parameters(vararg values: ArtifactParameterPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The status of the artifact.
     */
    @JvmName("bajarhrmgjesyffk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The status message from the virtual machine extension.
     */
    @JvmName("lofkkacexwbxijrq")
    public suspend fun vmExtensionStatusMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmExtensionStatusMessage = mapped
    }

    internal fun build(): ArtifactInstallPropertiesArgs = ArtifactInstallPropertiesArgs(
        artifactId = artifactId,
        artifactTitle = artifactTitle,
        deploymentStatusMessage = deploymentStatusMessage,
        installTime = installTime,
        parameters = parameters,
        status = status,
        vmExtensionStatusMessage = vmExtensionStatusMessage,
    )
}
