@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesCustomArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.CustomImageOsType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties for creating a custom image from a VHD.
 * @property imageName The image name.
 * @property osType The OS type of the custom image (i.e. Windows, Linux)
 * @property sysPrep Indicates whether sysprep has been run on the VHD.
 */
public data class CustomImagePropertiesCustomArgs(
    public val imageName: Output<String>? = null,
    public val osType: Output<Either<String, CustomImageOsType>>,
    public val sysPrep: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesCustomArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesCustomArgs =
        com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesCustomArgs.builder()
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .osType(
                osType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sysPrep(sysPrep?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomImagePropertiesCustomArgs].
 */
@PulumiTagMarker
public class CustomImagePropertiesCustomArgsBuilder internal constructor() {
    private var imageName: Output<String>? = null

    private var osType: Output<Either<String, CustomImageOsType>>? = null

    private var sysPrep: Output<Boolean>? = null

    /**
     * @param value The image name.
     */
    @JvmName("coctvyhjnwrkuuxa")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value The OS type of the custom image (i.e. Windows, Linux)
     */
    @JvmName("numutldjnawgelhn")
    public suspend fun osType(`value`: Output<Either<String, CustomImageOsType>>) {
        this.osType = value
    }

    /**
     * @param value Indicates whether sysprep has been run on the VHD.
     */
    @JvmName("eficnvxhwkifeypb")
    public suspend fun sysPrep(`value`: Output<Boolean>) {
        this.sysPrep = value
    }

    /**
     * @param value The image name.
     */
    @JvmName("gelhvjusycghmjyk")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value The OS type of the custom image (i.e. Windows, Linux)
     */
    @JvmName("usluissylljvajsv")
    public suspend fun osType(`value`: Either<String, CustomImageOsType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The OS type of the custom image (i.e. Windows, Linux)
     */
    @JvmName("crbyyhcpdljlveyu")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CustomImageOsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The OS type of the custom image (i.e. Windows, Linux)
     */
    @JvmName("kwoxhblqrnuonokb")
    public fun osType(`value`: CustomImageOsType) {
        val toBeMapped = Either.ofRight<String, CustomImageOsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Indicates whether sysprep has been run on the VHD.
     */
    @JvmName("flcpiyfhpqusjdyo")
    public suspend fun sysPrep(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sysPrep = mapped
    }

    internal fun build(): CustomImagePropertiesCustomArgs = CustomImagePropertiesCustomArgs(
        imageName = imageName,
        osType = osType ?: throw PulumiNullFieldException("osType"),
        sysPrep = sysPrep,
    )
}
