@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromVmArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties for creating a custom image from a virtual machine.
 * @property linuxOsInfo The Linux OS information of the VM.
 * @property sourceVmId The source vm identifier.
 * @property windowsOsInfo The Windows OS information of the VM.
 */
public data class CustomImagePropertiesFromVmArgs(
    public val linuxOsInfo: Output<LinuxOsInfoArgs>? = null,
    public val sourceVmId: Output<String>? = null,
    public val windowsOsInfo: Output<WindowsOsInfoArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromVmArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromVmArgs =
        com.pulumi.azurenative.devtestlab.inputs.CustomImagePropertiesFromVmArgs.builder()
            .linuxOsInfo(linuxOsInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceVmId(sourceVmId?.applyValue({ args0 -> args0 }))
            .windowsOsInfo(windowsOsInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomImagePropertiesFromVmArgs].
 */
@PulumiTagMarker
public class CustomImagePropertiesFromVmArgsBuilder internal constructor() {
    private var linuxOsInfo: Output<LinuxOsInfoArgs>? = null

    private var sourceVmId: Output<String>? = null

    private var windowsOsInfo: Output<WindowsOsInfoArgs>? = null

    /**
     * @param value The Linux OS information of the VM.
     */
    @JvmName("dhxyejfktvxscdmm")
    public suspend fun linuxOsInfo(`value`: Output<LinuxOsInfoArgs>) {
        this.linuxOsInfo = value
    }

    /**
     * @param value The source vm identifier.
     */
    @JvmName("gdnymbaflvlhvrbs")
    public suspend fun sourceVmId(`value`: Output<String>) {
        this.sourceVmId = value
    }

    /**
     * @param value The Windows OS information of the VM.
     */
    @JvmName("dpvojpnqnkjeerhm")
    public suspend fun windowsOsInfo(`value`: Output<WindowsOsInfoArgs>) {
        this.windowsOsInfo = value
    }

    /**
     * @param value The Linux OS information of the VM.
     */
    @JvmName("rmjpyuadmdcsjqqw")
    public suspend fun linuxOsInfo(`value`: LinuxOsInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxOsInfo = mapped
    }

    /**
     * @param argument The Linux OS information of the VM.
     */
    @JvmName("lpfqwngbhbcvemmg")
    public suspend fun linuxOsInfo(argument: suspend LinuxOsInfoArgsBuilder.() -> Unit) {
        val toBeMapped = LinuxOsInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linuxOsInfo = mapped
    }

    /**
     * @param value The source vm identifier.
     */
    @JvmName("kjrbipuxxyvvyuys")
    public suspend fun sourceVmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVmId = mapped
    }

    /**
     * @param value The Windows OS information of the VM.
     */
    @JvmName("oqtmvvcqfysqjhpg")
    public suspend fun windowsOsInfo(`value`: WindowsOsInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsOsInfo = mapped
    }

    /**
     * @param argument The Windows OS information of the VM.
     */
    @JvmName("mxatmwndyqetdaqd")
    public suspend fun windowsOsInfo(argument: suspend WindowsOsInfoArgsBuilder.() -> Unit) {
        val toBeMapped = WindowsOsInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.windowsOsInfo = mapped
    }

    internal fun build(): CustomImagePropertiesFromVmArgs = CustomImagePropertiesFromVmArgs(
        linuxOsInfo = linuxOsInfo,
        sourceVmId = sourceVmId,
        windowsOsInfo = windowsOsInfo,
    )
}
