@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devtestlab.kotlin.inputs

import com.pulumi.azurenative.devtestlab.inputs.DataDiskPropertiesArgs.builder
import com.pulumi.azurenative.devtestlab.kotlin.enums.HostCachingOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Request body for adding a new or existing data disk to a virtual machine.
 * @property attachNewDataDiskOptions Specifies options to attach a new disk to the virtual machine.
 * @property existingLabDiskId Specifies the existing lab disk id to attach to virtual machine.
 * @property hostCaching Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
 */
public data class DataDiskPropertiesArgs(
    public val attachNewDataDiskOptions: Output<AttachNewDataDiskOptionsArgs>? = null,
    public val existingLabDiskId: Output<String>? = null,
    public val hostCaching: Output<Either<String, HostCachingOptions>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devtestlab.inputs.DataDiskPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devtestlab.inputs.DataDiskPropertiesArgs =
        com.pulumi.azurenative.devtestlab.inputs.DataDiskPropertiesArgs.builder()
            .attachNewDataDiskOptions(
                attachNewDataDiskOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .existingLabDiskId(existingLabDiskId?.applyValue({ args0 -> args0 }))
            .hostCaching(
                hostCaching?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataDiskPropertiesArgs].
 */
@PulumiTagMarker
public class DataDiskPropertiesArgsBuilder internal constructor() {
    private var attachNewDataDiskOptions: Output<AttachNewDataDiskOptionsArgs>? = null

    private var existingLabDiskId: Output<String>? = null

    private var hostCaching: Output<Either<String, HostCachingOptions>>? = null

    /**
     * @param value Specifies options to attach a new disk to the virtual machine.
     */
    @JvmName("oabpvhliyrdgxree")
    public suspend fun attachNewDataDiskOptions(`value`: Output<AttachNewDataDiskOptionsArgs>) {
        this.attachNewDataDiskOptions = value
    }

    /**
     * @param value Specifies the existing lab disk id to attach to virtual machine.
     */
    @JvmName("cttwjcvwvyiujitm")
    public suspend fun existingLabDiskId(`value`: Output<String>) {
        this.existingLabDiskId = value
    }

    /**
     * @param value Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
     */
    @JvmName("vjvqkvoglawbyexi")
    public suspend fun hostCaching(`value`: Output<Either<String, HostCachingOptions>>) {
        this.hostCaching = value
    }

    /**
     * @param value Specifies options to attach a new disk to the virtual machine.
     */
    @JvmName("hxcxjpqtntkpstsx")
    public suspend fun attachNewDataDiskOptions(`value`: AttachNewDataDiskOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachNewDataDiskOptions = mapped
    }

    /**
     * @param argument Specifies options to attach a new disk to the virtual machine.
     */
    @JvmName("xikjkckpmlyiqfqx")
    public suspend
    fun attachNewDataDiskOptions(argument: suspend AttachNewDataDiskOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = AttachNewDataDiskOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attachNewDataDiskOptions = mapped
    }

    /**
     * @param value Specifies the existing lab disk id to attach to virtual machine.
     */
    @JvmName("pkbwggvujsllibow")
    public suspend fun existingLabDiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.existingLabDiskId = mapped
    }

    /**
     * @param value Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
     */
    @JvmName("bbspejcokcvfnkga")
    public suspend fun hostCaching(`value`: Either<String, HostCachingOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostCaching = mapped
    }

    /**
     * @param value Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
     */
    @JvmName("qadaiofoenhogapu")
    public fun hostCaching(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HostCachingOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostCaching = mapped
    }

    /**
     * @param value Caching option for a data disk (i.e. None, ReadOnly, ReadWrite).
     */
    @JvmName("hjgasgpoimuoases")
    public fun hostCaching(`value`: HostCachingOptions) {
        val toBeMapped = Either.ofRight<String, HostCachingOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostCaching = mapped
    }

    internal fun build(): DataDiskPropertiesArgs = DataDiskPropertiesArgs(
        attachNewDataDiskOptions = attachNewDataDiskOptions,
        existingLabDiskId = existingLabDiskId,
        hostCaching = hostCaching,
    )
}
